# CVE-2025-11749
AI Engine &lt;= 3.1.3 - Unauthenticated Sensitive Information Exposure to Privilege Escalation
# ⚠️ AI Engine <= 3.1.3 — Unauthenticated Sensitive Information Exposure → Privilege Escalation

**GitHub:** [Nxploited](https://github.com/Nxploited)  
**Telegram:** [@KNxploited](https://t.me/KNxploited)  

---

**IMPORTANT NOTICE:**  
**Many unethical individuals attempt to profit from the code I create by reselling it or renaming scripts and claiming authorship. This project is free, exclusive, and officially released by Khaled Alenazi (Nxploited).**

---

## 🔎 Summary

The AI Engine plugin for WordPress (versions up to and including **3.1.3**) suffers from an information disclosure vulnerability allowing unauthenticated users to fetch internal bearer/session tokens through exposed REST API endpoints if certain plugin configurations are enabled. An attacker with such a token can escalate privileges, including the creation of administrator accounts, resulting in complete site compromise.

- **Affected Product:** AI Engine (WordPress plugin)  
- **Affected Versions:** ≤ 3.1.3  
- **Vulnerability:** Sensitive Information Exposure → Privilege Escalation  
- **CVE:** CVE-2025-11749  
- **CVSS v3:** 9.8 (Critical)

![Script demonstration](https://github.com/Nxploited/CVE-2025-11749/blob/main/1.png)

100

---

## 📋 Quick Reference

| Field           | Value                                            |
|-----------------|--------------------------------------------------|
| Vulnerability   | Unauthenticated Sensitive Information Exposure    |
| Product         | AI Engine (WordPress plugin)                     |
| Affected ver.   | ≤ 3.1.3                                          |
| CVE             | CVE-2025-11749                                   |
| CVSS (v3)       | 9.8 (Critical)                                   |
| Impact          | Privilege Escalation, Admin Account Creation     |

---

## ✨ Features

- **Fast multithreaded scanning of large target lists**
- **Auto extraction and logging of valid tokens per site**
- **Clear and organized output files for analysis**
- **Automated admin account creation & login verification**
- **Professional CLI prompts and stylish console output**

---

## 🚀 How To Use

**Script filename:** `CVE-2025-11749.py`  
**Requires:** Python 3.8+ (recommended 3.10+), [requests](https://pypi.org/project/requests/), [rich](https://pypi.org/project/rich/)

### 1. Prepare Your Environment

**Linux/macOS:**
```bash
python3 -m venv .venv
source .venv/bin/activate
python -m pip install --upgrade pip
pip install requests rich
```

**Windows (PowerShell):**
```powershell
python -m venv .venv
.\.venv\Scripts\Activate.ps1
python -m pip install --upgrade pip
pip install requests rich
```

---

### 2. Create Your Targets File

Create a file named `list.txt`  
- Add one website URL per line (with http:// or https://)

Example:
```
https://example1.com
http://example2.com
```

---

### 3. Run The Script

**Interactive (recommended):**
```bash
python CVE-2025-11749.py
```
- The script will prompt for the targets file name and thread count.

**Non-interactive (if you or your version supports CLI flags):**
```bash
python CVE-2025-11749.py --targets list.txt --threads 10
```

---

### 4. Review Output Files

- `tokens_only.txt` — Targets with a detected token  
- `success_results.txt` — Targets where privilege escalation worked  
- `created_admins.txt` — Details on successfully created admin accounts

Output is saved automatically in the working directory. Each output is formatted for clarity and post‑analysis.

---

## 💡 Notes

- Use on LEGAL targets only.
- For large lists, increase thread count as needed.
- For multi-run automation, break up list.txt into manageable chunks.

---

## 🛡️ Mitigation & Patch Guidance

1. **Update:** Upgrade AI Engine to the latest version.  
2. **Disable:** Remove settings that expose tokens to unauthenticated requests (e.g., "No-Auth URL").  
3. **Rotate:** Change all session tokens, nonces, credentials after patching.
4. **Restrict:** Use WAF/IP allowlist to control REST API access.
5. **Audit:** Monitor logs and review users for privilege abuse.

---

## 🧾 Legal Disclaimer

This project is distributed for educational and authorized assessment purposes only.  
Any usage against unauthorized systems is strictly prohibited.  
By using this script, you agree to comply with all laws and regulations.

---

**By: Khaled Alenazi (Nxploited)**  
**GitHub:** [Nxploited](https://github.com/Nxploited)  
**Telegram:** [@KNxploited](https://t.me/KNxploited)  
