# CVE-2025-1094: SQL Injection to RCE via WebSocket 🚀

This repository contains a proof of concept (PoC) exploit for **CVE-2025-1094**, a vulnerability in PostgreSQL that allows an SQL Injection (SQLi) attack to escalate to Remote Code Execution (RCE) through WebSocket hijacking.

## Overview

This exploit leverages an SQL Injection vulnerability in PostgreSQL to inject malicious code that reads sensitive files, such as `/etc/passwd`, and stores them on the vulnerable server. The exploit then hijacks an active WebSocket connection to execute arbitrary commands, ultimately achieving a remote shell on the compromised server.

## Vulnerability Details

- **CVE ID**: CVE-2025-1094
- **Vulnerable System**: PostgreSQL (misconfigured functions)
- **Exploit Path**: SQL Injection → WebSocket Hijacking → Remote Code Execution (RCE)

## How It Works

1. **SQL Injection (SQLi)**: The attack begins with injecting malicious SQL commands into a vulnerable PostgreSQL endpoint. The payload uses `lo_export` to read sensitive files from the server.
   
2. **WebSocket Hijacking**: The attacker hijacks an open WebSocket connection and sends a payload to execute the RCE. This triggers a reverse shell connection back to the attacker’s system.

3. **Remote Code Execution (RCE)**: The reverse shell provides the attacker full control over the server, allowing further exploitation.

## PoC (Proof of Concept)

```sql
SELECT lo_export( (SELECT convert_from(pg_read_file('/etc/passwd'), 'UTF8')), '/tmp/payload');
```

The above SQL payload reads the `/etc/passwd` file and saves it as `/tmp/payload`. Once the file is retrieved, the exploit uses WebSocket hijacking to establish a reverse shell.

## How to Use

1. Clone the repository:

   ```bash
   git clone https://github.com/soltanali0/CVE-2025-1094.git
   cd CVE-2025-1094
   ```

2. Modify the following variables in the script:

   - `REVERSE_IP`: Your attacker's IP address
   - `REVERSE_PORT`: The port on which your listener is running
   - `TARGET_URL`: The vulnerable endpoint to attack
   - `WEBSOCKET_URL`: The WebSocket URL to hijack

3. Run the script to exploit the vulnerability and establish a reverse shell.

4. Start your netcat listener on the specified port:

   ```bash
   nc -lvnp <REVERSE_PORT>
   ```

## Mitigation

To protect against this vulnerability:

- **Use Prepared Statements**: Replace dynamic SQL queries with prepared statements.
- **Validate User Inputs**: Always validate and sanitize user inputs to prevent SQL Injection.
- **Restrict PostgreSQL Functions**: Limit access to functions like `lo_export` to trusted users only.
- **Secure WebSocket Connections**: Ensure WebSocket connections are authenticated and encrypted.
- **Keep PostgreSQL Updated**: Apply the latest security patches and review your PostgreSQL configuration.

## Disclaimer

This exploit is intended for educational purposes only. Ensure that you have explicit permission before testing any system with this exploit. Unauthorized access to computer systems is illegal.

