# CVE-2025-10878

## SQL Authentication Bypass in Fikir Odaları AdminPando

### Summary

| Field | Value |
|-------|-------|
| CVE ID | CVE-2025-10878 |
| Product | Fikir Odaları AdminPando |
| Vendor | Omran İnşaat A.Ş. |
| Vulnerable URL | https://www.omran.com.tr/admin/logIn.php |
| Affected Version | v1.0.1 (and possibly earlier) |
| Vulnerability Type | CWE-89: SQL Injection |
| CVSS v3.1 Score | 10.0 (Critical) |
| CVSS Vector | AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H |
| Patch Date | 2026-01-26 |
| Researcher | Onurcan Genç |

---

### Description

A SQL injection vulnerability exists in the login functionality of Fikir Odaları AdminPando v1.0.1. The `username` and `password` parameters are vulnerable to SQL injection, allowing unauthenticated attackers to bypass authentication completely.

Successful exploitation grants full administrative access to the application, including the ability to manipulate the public-facing website content (HTML/DOM manipulation).

---

### CVSS v3.1 Score

| Metric | Value |
|--------|-------|
| Vector | `AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H` |
| Base Score | **10.0 (Critical)** |
| Scope | Changed (S:C) |

**Scope: Changed (S:C) Justification:**

The vulnerability exists in the admin panel authentication (`/admin`), but successful exploitation impacts a completely separate user population mostly public website visitors.

**Attack Flow:**
1. Attacker exploits SQLi on `/admin` login page (vulnerable component)
2. Attacker gains admin dashboard access
3. Admin dashboard provides full HTML/DOM control over the public website
4. Public website visitors (impacted component) receive manipulated content

This crosses a trust boundary: unauthenticated attacker → admin privileges → impact on public users who have no interaction with the admin panel.

---

### Affected Parameters

- `username` (text input)
- `password` (password input)

---

### Proof of Concept

#### 1) Discovery

The `/admin` endpoint was discovered using directory enumeration. The login form contains two vulnerable input fields.

![01-endpoint-discovery.png](./screenshots/01-endpoint-discovery.png)

The application page is accessed, and the input parameters containing the vulnerability are identified.

![02-identify-target.png](./screenshots/02-identify-target.png)

#### 2) Exploitation

**Payload:**
```
' OR '1'='1
```

**Method:**
```
Username: ' OR '1'='1
Password: [anything]

OR

Username: [anything]
Password: ' OR '1'='1
```

![03-login-page.png](./screenshots/03-login-page.png)

(In the demonstrated scenario, only the username parameter was tested for validation purposes; however, the vulnerability is triggered across all input surfaces.)

By clicking the login button, access to the admin panel is obtained.

![04-admin-panel.png](./screenshots/04-admin-panel.png)

#### 3) Result

Authentication was bypassed successfully. Admin panel access was achieved. From the admin panel, full HTML/DOM manipulation of the public-facing website is possible, including:

- Changing homepage logo
- Modifying page content
- Full HTML/DOM control

---

### Impact

- Complete authentication bypass
- Unauthorized administrative access
- Full HTML/DOM manipulation of public website
- Malicious content distribution to visitors
- Brand/reputation damage
- Potential user data exposure

---

### Timeline

| Date | Event |
|------|-------|
| 2025-09-23 | Vulnerability reported to USOM (TR-CERT), CVE assigned |
| 2025-09 to 2026-01 | No response from vendor/CNA (4+ months) |
| 2026-01-02 | MITRE escalation submitted |
| 2026-01-23 | MITRE contacted USOM |
| 2026-01-26 | USOM rejected CVE as "single instance" |
| 2026-01-26 | Vulnerability patched (verified by researcher) |
| 2026-01-29 | MITRE accepted CVE under CNA of Last Resort |

---

### Remediation

The vulnerability was patched on 2026-01-26. Users should ensure they are running the latest version of the software.

![05-fix-applied.png](./screenshots/05-fix-applied.png)

---

### References

- [MITRE CVE Record](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2025-10878)
- [NVD Entry](https://nvd.nist.gov/vuln/detail/CVE-2025-10878)

---

### Documentation

- [English PoC](./README.md)
- [Original Turkish Report](./ORIGINAL_REPORT_TR.md)

---

### Disclaimer

This vulnerability was discovered and reported through responsible disclosure practices. No data was extracted, modified, or any action taken that would compromise the integrity of the system.

---

### Credit

Discovered by **Onurcan Genç**

- GitHub: [@onrcngnc](https://github.com/onrcngnc)
- LinkedIn: [Onurcan Genç](https://linkedin.com/in/onurcangenc)
- Personal Page: [Onurcan Genç](https://onurcangenc.com.tr)
- Blog About CVE-2025-10878: [Onurcan Genç](https://onurcangenc.com.tr/posts/cve-2025-10878-sql-authentication-bypass-in-fikir-odalar%C4%B1-adminpando/)