# CVE-2025-10230 — Samba WINS Hook Command Injection

The author assumes no liability for misuse or damage caused by this tool.  
Research is provided strictly for educational and defensive purposes.

---

## Description

This repository contains a Proof-of-Concept (PoC) for **CVE-2025-10230**, a command-injection flaw in the **WINS hook** mechanism of Samba.

The flaw affects Samba installations where:

- `wins support = yes` is enabled
- A custom shell command is defined in `wins hook = ...`
- The server receives a **malformed NetBIOS registration** request
- The NetBIOS name is concatenated **directly into the shell invocation**, enabling code execution

This PoC demonstrates how specially crafted **NetBIOS Name Registration** packets can trigger arbitrary shell commands inside Samba.

---

### Technical Information
CVE-2025-10230 is a command injection vulnerability in Samba's WINS server implementation, specifically when acting as an Active Directory Domain Controller with both WINS support and a 'wins hook' parameter configured.

- Vulnerability Mechanism: When a WINS registration packet is received, the NetBIOS name from the packet is inserted directly into a shell command that is executed by the Samba process. No validation or escaping is performed on the NetBIOS name, which can be up to 15 characters and may include shell metacharacters.
- Attack Vector: An attacker sends a specially crafted WINS registration packet to UDP port 137 containing a NetBIOS name with shell metacharacters (such as ;, |, &, or backticks). The injected shell code is executed with the privileges of the Samba process, often root.
- Root Cause: Lack of input sanitization for the NetBIOS name field before passing it to a shell command (CWE-78: OS Command Injection).
- Affected Configuration: Only Samba servers acting as Active Directory Domain Controllers with 'wins support = yes' and a non-empty 'wins hook' parameter in smb.conf are vulnerable. The default configuration is not affected.

### CVSSv3 calculation
```CVSS:3.1: CRITICAL
CVSS:3.1: AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H  (10.0)
```

### Patch Availability

Patches addressing this issue have been posted to:

    https://www.samba.org/samba/security/

Additionally, Samba 4.23.2, 4.22.5, and 4.21.9 have been issued as
security releases to correct the defect. Samba administrators are
advised to upgrade to these releases or apply the patch as soon as
possible.

## Attack Vector (Technical Summary)

1. The attacker crafts a NetBIOS Name Service (NBNS) registration packet
2. The name contains payload characters within the allowed **≤15-character limit**
3. Samba receives the WINS request on **port 137/UDP**
4. The `wins hook` handler executes with **unsanitized input**
5. The payload runs with the privileges of the Samba daemon (often **root**)

### Constraints

- NetBIOS names **cannot contain `< > ;`**
- Payload size must be **≤ 15 chars**
- Injection happens through **positional arguments**

Example commands that execute successfully:

```bash
ls
pwd
uname
```

## dir: /etc/samba/smb.conf
```conf
[global]
    wins support = yes
    wins hook = /usr/bin/ls
```

## PoC Usage

```bash
python3 poc/cve-2025-10230.py \
    -t <TARGET_IP> \
    -n <PAYLOAD_NAME> \
    -i <SOURCE_IP>
```

## Example 192.168.0.10 (Samba Server) | bin (Show Directory) | 192.168.0.50 (whatever)
```bash
python3 poc/cve-2025-10230.py -t 192.168.0.10 -n bin -i 192.168.0.50
```

## Repository Structure

```
CVE-2025-10230/
│
├── poc/
│   └── cve-2025-10230.py
│
├── evidence/
│   └── logs.md
│
├── conf/
│   └── smb.conf
│
└── README.md
```


## Author & Contact
	- Researcher: krakhen.dev
	- GitHub: @nehkark
	- Email: krakhen@gmail.com
	- Website: https://vciso.cloud
	- Reference: https://github.com/dptsec/CVE-2025-10230/
