# APK Build for CVE‑2025‑10184 PoC

这是一个 **CVE‑2025‑10184** 的 **PoC** 的 APK 构建

该漏洞存在于 com.\*.providers.telephony 中, 允许任意应用在未获得 SMS 读取权限的情况下读取短信

---

## 源码

此源码及更多细节可见 Rapid7 的文章：  
https://www.rapid7.com/blog/post/cve-2025-10184-oneplus-oxygenos-telephony-provider-permission-bypass-not-fixed/

---

## 下载

请登录后在 Actions 下载 **未签名** 的安装包

---

## 验证

已确认 OPPO 及其子品牌, 自 ColorOS 7.1 的所有版本均受影响

---

## 修复

OPPO 官方已修复此问题 (通过替换 Provider 声明的权限为 OPLUS_COMPONENT_SAFE), 目前正在逐步推送更新

---

## 等不了 OPPO 了, 我他妈自己修

最简单的修复方法：只需要在操作之前验证调用者是否拥有 SMS 权限  
注：此方法已验证可以防止读取, 并且不影响真正拥有 SMS 权限的应用读取, 但是未进行其他可用性影响测试

在 `ServiceNumberProvider` 类的 `update` 方法开头添加运行时权限检查：
```diff
 .method public update(Landroid/net/Uri;Landroid/content/ContentValues;Ljava/lang/String;[Ljava/lang/String;)I
     .registers 8

+    invoke-virtual {p0}, Lcom/android/providers/telephony/ServiceNumberProvider;->getContext()Landroid/content/Context;
+    move-result-object v0
+    
+    const-string v1, "android.permission.READ_SMS"
+    const-string v2, "Requires READ_SMS permission"
+    invoke-virtual {v0, v1, v2}, Landroid/content/Context;->enforceCallingPermission(Ljava/lang/String;Ljava/lang/String;)V
+   
     .line 157
     iget-object p0, p0, Lcom/android/providers/telephony/ServiceNumberProvider;->mOpenHelper:Lcom/android/providers/telephony/MmsSmsDatabaseHelper;
 
     invoke-virtual {p0}, Lcom/android/providers/telephony/MmsSmsDatabaseHelper;->getWritableDatabase()Landroid/database/sqlite/SQLiteDatabase;
 
     move-result-object p0
 
     # ... 省略其余原有代码
 .end method
```
在 `PushMessageProvider` 类和 `PushShopProvider` 类的 `update` 方法也需要添加以上代码  

修改后请 **不要签名** 并且需要 **核心破解** 后安装, 否则将破坏整个通话功能并丢失所有短信 (系统安全机制所致)
