# 7-Zip Mark-of-the-Web Bypass Vulnerability [CVE-2025-0411] - POC

## CVE-2025-0411 Details

"This vulnerability (CVSS SCORE	7.0) allows remote attackers to bypass the Mark-of-the-Web protection mechanism on affected installations of 7-Zip. User interaction is required to exploit this vulnerability in that the target must visit a malicious page or open a malicious file.
The specific flaw exists within the handling of archived files. When extracting files from a crafted archive that bears the Mark-of-the-Web, 7-Zip does not propagate the Mark-of-the-Web to the extracted files. An attacker can leverage this vulnerability to execute arbitrary code in the context of the current user."

## Vulnerable Versions
- All versions before **24.09** are considered vulnerable.

## Mitigations
- "Update 7-Zip: Download and install version 24.09 or later from the official 7-Zip website."
- "Exercise Caution with Untrusted Files: Avoid opening files from unknown or suspicious sources, especially compressed archives."
- "Leverage Security Features: Ensure that your operating system and security software are configured to detect and block malicious files."

## Proof Of Concept
As part of POC a simple loader of calc.exe is implemented.

### Weaponization
The methodology is to double compress the executable which triggers the vulnerability. 

![weaponization](https://github.com/user-attachments/assets/dd0a1975-308c-49a8-a938-521eb3c751a6)

### Delivery
Next, the double compressed 7Zip file is uploaded on a payload delivery server (in this scenario MediaFire) and delivered to the victim i.e. through phishing emails serving the malicious URL. 
Upon downloading the file, the "MotW" (Zone.Identifier - The origin of the download) can be seen:

![motw](https://github.com/user-attachments/assets/90061d91-f7b3-4d15-ba29-45e09fe97a09)

### Execution
As part of the execution the victim needs to click through the compressed files and run the executable.

#### Patched Version
In this scenario the 7Zip 24.09 version (patched) is used which displays the Windows SmartScreen warning that this file comes from an untrusted source (since it contains the MotW).

![patched](https://github.com/user-attachments/assets/616172f1-5eae-47e4-b42d-a8bb0347a068)

#### Vulnerable Version
In this scenario the 7Zip 24.07 version (vulnerable) is used which allows direct execution of the executable without displaying any warnings (since it does not contain the MotW).

![vulnerable](https://github.com/user-attachments/assets/a0e84f09-aec8-4c07-88cd-be1227c1325f)

## References
- https://www.zerodayinitiative.com/advisories/ZDI-25-045/
- https://nvd.nist.gov/vuln/detail/CVE-2025-0411
- https://securityonline.info/cve-2025-0411-7-zip-security-vulnerability-enables-code-execution-update-now/
