# CVE-2025-0401 - Local Privilege Escalation via SUID Binary Abuse

## Summary

CVE-2025-0401 is a local privilege escalation vulnerability discovered in systems where the `/usr/bin/passwd` binary is misconfigured, allowing unintended root-level access when combined with specific syscall sequences. This exploit demonstrates how attackers can leverage SUID misconfigurations to simulate root shell access.

> ⚠️ This PoC is intended for educational and authorized testing environments only.

---

## Exploit Details

The vulnerability is triggered through direct syscalls involving:
- `setuid(0)`
- `setgid(0)`
- Execution of `/bin/sh`

### Syscalls used:
- `write` (1)
- `setuid` (105)
- `setgid` (106)
- `execve` (59)
- `exit` (60)

---

## Usage

```bash
git clone https://github.com/CyberSecurityUP/CVE-2025-0401.git
cd CVE-2025-0401
gcc -z execstack -fno-stack-protector exploit.c -o exploit
chmod +x exploit
./exploit
```

"Not everything said with a smile is true... especially on April 1st."
