# modules/session_handler.py
import os
import webbrowser
import json

def save_cookie(username, cookie_dict):
    os.makedirs("logs", exist_ok=True)
    filename = f"logs/{username}_cookie.json"
    with open(filename, "w") as f:
        json.dump(cookie_dict, f, indent=4)
    print(f"[+] Session cookie saved: {filename}")

def auto_login(base_url, cookie_dict):
    print("[*] Attempting browser auto-login...")
    from http.cookiejar import CookieJar
    import http.cookies
    import browser_cookie3
    # Optional: Create HTML form to simulate login
    login_url = base_url + "wp-admin/"
    print(f"[✓] Opening browser at: {login_url}")
    webbrowser.open(login_url)
    # Future: inject cookies into browser session (optional advanced)
