# utils/helpers.py
import os

def load_user_agents():
    try:
        with open("utils/user_agents.txt", "r") as f:
            return [ua.strip() for ua in f.readlines() if ua.strip()]
    except:
        return [
            "Mozilla/5.0 (Windows NT 10.0; Win64; x64)",
            "Mozilla/5.0 (X11; Linux x86_64)",
            "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7)"
        ]

def load_proxies():
    path = "utils/proxies.txt"
    if os.path.exists(path):
        with open(path, "r") as f:
            return [p.strip() for p in f.readlines() if p.strip()]
    return []

def banner():
    if os.path.exists("assets/banner.txt"):
        with open("assets/banner.txt", "r") as f:
            print(f.read())
    else:
        print("\n=== CVE-2025-0316 EXPLOIT ===")
