# CVE-2025-0054 – SAP NetWeaver Stored XSS Scanner 🕷

A lightweight Python tool to detect stored Cross-Site Scripting (XSS) vulnerabilities in **SAP NetWeaver Application Server Java**, specifically targeting **CVE-2025-0054**.

> ⚠️ For **educational and authorized security testing only**. Do **not** use on systems without permission.

---

##  About the Vulnerability

**CVE-2025-0054** is a stored XSS vulnerability in SAP NetWeaver Java systems, allowing attackers with low-level privileges to inject malicious JavaScript into the server, which is then stored and executed when users view affected pages.

---

##  Features

- Submits a customizable XSS payload to a target field
- Automatically checks the same page for stored payloads
- Detects presence of `<script>` tags or payload reflection
- Lightweight and fast — written in Python using `requests` and `BeautifulSoup`

---

##  Setup

### Requirements
- Python 3.x
- `requests`
- `beautifulsoup4`

```bash
pip install requests beautifulsoup4
 Usage
bash
Copy
Edit
python3 scanner.py
Edit the following in scanner.py before running:

TARGET_URL: Base URL of the SAP instance

VULN_ENDPOINT: Path to the vulnerable endpoint (e.g. /user/profile)

COOKIE: Your session cookie (can be copied from browser dev tools)

XSS_PAYLOAD: Payload to test (default: <script>alert('xss')</script>)

🛠 Example
python
Copy
Edit
TARGET_URL = "http://example-sap-host.com"
VULN_ENDPOINT = "/user/profile"
COOKIE = {"JSESSIONID": "your-session-id"}
XSS_PAYLOAD = "<script>alert('xss')</script>"
 How it works
Sends a POST request with the XSS payload to the target endpoint

Fetches the page again

Parses the response to detect stored script payloads

 Disclaimer
This tool is intended only for ethical hacking, educational purposes, or authorized penetration testing. The author is not responsible for any misuse or illegal activity.
