# wordpress-jetpack-broken-access-control-exploit

This is a Python3 program that exploits Jetpack < 13.9.1 broken access control vulnerability (CVE-2024-9926).

## DISCLAIMER

**This tool is intended for security engineers and appsec people for security assessments. Please use this tool responsibly. I do not take responsibility for the way in which any one uses this application. I am NOT responsible for any damages caused or any crimes committed by using this tool.**

## Vulnerability info

* **CVE-ID**: CVE-2024-9926
* **Link**: [https://www.cve.org/CVERecord?id=CVE-2024-9926](https://www.cve.org/CVERecord?id=CVE-2024-9926)
* **Description**: This vulnerability could be used by any logged in users on a site to read forms submitted by visitors on the site.
* **Vendor link**: [https://jetpack.com/blog/jetpack-13-9-1-critical-security-update/](https://jetpack.com/blog/jetpack-13-9-1-critical-security-update/)
* **Fix:** [https://github.com/Automattic/jetpack-production/commit/18605ae8cdc7438c2088336c51f3db8d6a5b90fd](https://github.com/Automattic/jetpack-production/commit/18605ae8cdc7438c2088336c51f3db8d6a5b90fd)
* **Official PoC:** [https://wpscan.com/vulnerability/669382af-f836-4896-bdcb-5c6a57c99bd9/](https://wpscan.com/vulnerability/669382af-f836-4896-bdcb-5c6a57c99bd9/)

## Help

```
$ ./exploit.py --help
usage: exploit.py [-h] -t TARGET -u USERNAME -ap APPLICATION_PASSWORD [-v]

Exploit for Jetpack < 13.9.1 broken access control vulnerability. - v1.0 (2024-11-01)

options:
  -h, --help            show this help message and exit
  -t TARGET, --target TARGET
                        URL of the target WordPress
  -u USERNAME, --username USERNAME
                        Username of WordPress
  -ap APPLICATION_PASSWORD, --application-password APPLICATION_PASSWORD
                        Application Password generated for the user (it's NOT the user password)
  -v, --verbose         verbose mode
```

## Examples

```
./exploit.py -t https://localhost:1337 -u attacker -ap "AAAA 1111 bbbb 2222 CCCC 3333"
```

## Vulnerable application

A vulnerable application can be setup using [this repository](https://github.com/m3ssap0/wordpress-jetpack-broken-access-control-vulnerable-application).

## Authors

* **Antonio Francesco Sardella** - *implementation* - [m3ssap0](https://github.com/m3ssap0)

## License

See the [LICENSE](LICENSE) file for details.

## Acknowledgments

* [**Marc Montpas**](https://wpscan.com/vulnerability/669382af-f836-4896-bdcb-5c6a57c99bd9/), the security researcher who discovered the vulnerability.
