<div align="center">

# CVE-2024-9680 - TOR Browser 0day Exploit

![CVE](https://img.shields.io/badge/CVE-2024--9680-critical?style=flat&logo=cve)
![Severity](https://img.shields.io/badge/severity-critical-red)
![Status](https://img.shields.io/badge/status-patched-success)
![License](https://img.shields.io/badge/license-CC0--1.0-blue)
![Stars](https://img.shields.io/github/stars/moscovium-mc/Tor-0day-JavaScript-Exploit?style=social)

**UAF (Use-After-Free) in Animation Timelines - Remote Code Execution Vulnerability**

Actively exploited in the wild targeting Tor Browser users

**[View Analysis](exploit/index.html)** • **[Official CVE](https://nvd.nist.gov/vuln/detail/cve-2024-9680)**

</div>

---

## Overview

This repository contains a comprehensive analysis and educational demonstration of CVE-2024-9680, a critical UAF (use-after-free) vulnerability in Firefox's animation timeline management that allows remote code execution in the browser's content process.

### Affected Versions

- Firefox < 131.0.2
- Firefox ESR < 128.3.1, < 115.16.1
- Thunderbird < 131.0.1, < 128.3.1, < 115.16.0

### Patch Status

Patches applied: November 5, 2024

---

## Repository Contents

**Original Exploit Code**

The complete, unmodified exploit code from wild exploitation is preserved in this repository for research and analysis purposes. The code is provided exactly as it was found during active attacks.

**Educational Analysis**

A modified, safety-hardened version with detailed technical stage-by-stage breakdown of the exploitation process.

**Security Analysis**

The repository provides multiple ways to analyze the exploit:
- **Live Analysis Page**: Open exploit HTML to see complete exploit breakdown with safety modifications
- **Code Review**: Examine the original exploit code with detailed annotations
- **Technical Documentation**: Review the stage-by-stage exploitation process

---

## Exploitation Process

### Stage 1: Initialization
Encoded shellcode delivery via Web Workers

### Stage 2: DOM Crafting
Complex SVG animation structures with circular timing references

### Stage 3: Exploitation
Heap spraying and UAF trigger through animation attribute manipulation

### Stage 4: Post-Exploitation
Analysis of intended secondary payload delivery

---

## Key Vulnerable Components

- Firefox Animation Timeline Management
- SVG Animation Element Handling
- ArrayBuffer Heap Spraying
- Use-After-Free in `pauseAnimations()`

---

## Usage
```bash
git clone https://github.com/moscovium-mc/Tor-0day-JavaScript-Exploit
cd Tor-0day-JavaScript-Exploit
# Open exploit/index.html in a PATCHED browser for analysis
```

> [!NOTE]
> This exploit only works on unpatched versions. Make sure you are using a patched browser (Firefox >= 131.0.2) for analysis.

> [!TIP]
> For security researchers: Use a sandboxed VM environment when analyzing exploit code.

---

## Legal & Ethical Notice

> [!WARNING]
> **EDUCATIONAL AND RESEARCH PURPOSES ONLY**

This repository contains analysis of real-world exploit code for educational purposes.

> [!IMPORTANT]
> While dedicated to the public domain under CC0 1.0 Universal, users are solely responsible for compliance with all applicable laws and regulations. See [LICENSE](LICENSE) for complete terms.

### Intended Use

- Security education and training
- Defensive security research and threat analysis
- Academic study of exploitation techniques
- Improving software security and defensive measures
- Authorized vulnerability assessment and penetration testing

### Prohibited Use

- Unauthorized access to computer systems or networks
- Malicious attacks, exploitation, or damage to systems
- Any illegal activities or violation of computer crime laws
- Attacks against systems without explicit written authorization

> [!CAUTION]
> The original malicious functionality has been disabled and safety measures have been implemented. The authors assume no responsibility for misuse. Use ethically and legally.

---

## Resources

**Official References**

- [Mozilla Security Advisory](https://www.mozilla.org/en-US/security/advisories/)
- [CVE Details - CVE-2024-9680](https://nvd.nist.gov/vuln/detail/cve-2024-9680)
- [Tor Project Security](https://support.torproject.org/tor-browser/security/)

**Related Research**

- UAF exploitation techniques
- Browser sandbox escapes
- Heap spraying methodologies
