﻿import requests
from colorama import Fore, Style, init

init()

def read_targets(file_path):
    try:
        with open(file_path, 'r') as f:
            targets = [line.strip() for line in f.readlines()]
        return targets
    except FileNotFoundError:
        print(f"{Fore.RED}File {file_path} not found.{Style.RESET_ALL}")
        return []

target_file = "targets.txt"
vulnerable_file = "vulnerable.txt"
path = "/home/userSpace/devices/debug.txt"

def check_vulnerability(url):
    try:
        full_url = f"{url}{path}"
        response = requests.get(full_url, timeout=10, allow_redirects=False)

        if response.status_code == 200 and not response.history:
            print(f"{Fore.GREEN}{url} is vulnerable (200 OK){Style.RESET_ALL}")
            with open(vulnerable_file, 'a') as f:
                f.write(url + '\n')
        elif response.status_code == 404:
            print(f"{Fore.CYAN}{url} is not vulnerable (404 Not Found){Style.RESET_ALL}")
        elif response.is_redirect or response.history:
            print(f"{Fore.YELLOW}{url} redirects (Not vulnerable){Style.RESET_ALL}")
        else:
            print(f"{Fore.YELLOW}{url} returned status code: {response.status_code}{Style.RESET_ALL}")
    
    except requests.exceptions.RequestException as e:
        print(f"{Fore.RED}Error checking {url}: {e}{Style.RESET_ALL}")

targets = read_targets(target_file)

for target in targets:
    check_vulnerability(target)
