# CVE-2024-8743 PoC

## Background

Proof-of-Concept script for WordPress plugin Bit File Manager version <= 6.5.7 Authenticated (Subscriber+) Limited JavaScript File Upload (CVE-2024-8743) vulnerability

## Information

Description:

The Bit File Manager – 100% Free & Open Source File Manager and Code Editor for WordPress plugin for WordPress is vulnerable to Limited JavaScript File Upload in all versions up to, and including, 6.5.7. This is due to a lack of proper checks on allowed file types. This makes it possible for authenticated attackers, with Subscriber-level access and above, and granted permissions by an administrator, to upload .css and .js files, which could lead to Stored Cross-Site Scripting. (From [https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/file-manager/bit-file-manager-100-free-open-source-file-manager-and-code-editor-for-wordpress-657-authenticated-subscriber-limited-javascript-file-upload](https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/file-manager/bit-file-manager-100-free-open-source-file-manager-and-code-editor-for-wordpress-657-authenticated-subscriber-limited-javascript-file-upload))

## Technical Details

Writeup: [https://siunam321.github.io/ctf/Bug-Bounty/Wordfence/how-i-found-my-first-vulnerabilities-in-6-different-wordpress-plugins-part-2/#allowing-javascript-andor-css-files-upload---bit-file-manager-limited-file-upload](https://siunam321.github.io/ctf/Bug-Bounty/Wordfence/how-i-found-my-first-vulnerabilities-in-6-different-wordpress-plugins-part-2/#allowing-javascript-andor-css-files-upload---bit-file-manager-limited-file-upload)

## Installation

```bash
git clone https://github.com/siunam321/CVE-2024-8743-PoC.git
```

## Usage/Exploitation

- Prerequisite: Subscriber or above user access and shortcode `file-manager` must already been setup by the adminsitrator

Update the Python script `poc.py`'s `wordpressUsername`, `wordpressPassword`, `targetBaseUrl`, `fileManagerPostPath`, `attackerIpAddress`, and/or `attackerPort` to your desired value. Then, run `python3 poc.py` to run the PoC script.

PoC video demo:

https://github.com/user-attachments/assets/76571398-1b8c-4726-800c-9ed6c2928562
