
# CVE-2024-8682 - JNews Unauthenticated Registration PoC

**JNews** (<= 11.6.6) has a vulnerability that allows unauthenticated user registration via the `?ajax-request=jnews` endpoint, even when WordPress registration is disabled.

This works by first retrieving a valid `jnews_nonce` through the `jnews_refresh_nonce` action, then using it to register a new user via `register_handler`.

## Usage

```bash
python3 cve-2024-8682.py -u https://target.com -n newuser -e email@domain.com
```

### Arguments

- `-u`: Target WordPress URL
- `-n`: Username
- `-e`: Email

## References

- https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-themes/jnews/jnews-wordpress-newspaper-magazine-blog-amp-theme-1166-unauthorized-user-registration
- https://nvd.nist.gov/vuln/detail/CVE-2024-8682
