# CVE-2024-8465 – SQL Injection Proof of Concept

## Team Information

Team Name: The Misfits

Team Members:
- Muhammad Tayyab Nisar
- Oluwasola SAMUEL Abubakar
- Mohamed Melek Balghouthi

## Overview

This repository contains a vulnerable web application created as a Proof of Concept (PoC)
to demonstrate an SQL Injection vulnerability modeled after CVE-2024-8465.

The application is intentionally insecure and shows how improper input handling
can lead to authentication bypass and database data disclosure.

This project is for academic and educational purposes only.

## CVE Reference

https://www.cve.org/CVERecord?id=CVE-2024-8465

## Vulnerabilities Demonstrated

1. Authentication Bypass using SQL Injection
2. Unauthorized Data Disclosure using SQL Injection

## Vulnerable Login Endpoint

File: login.php

Vulnerable SQL Query:
SELECT id, username, role FROM users WHERE username='$username' AND password='$password'

Example Injection Payload:
' OR '1'='1' --

Impact:
An attacker can bypass authentication and log in without valid credentials.

## Vulnerable Search Endpoint

File: search.php

Vulnerable SQL Query:
SELECT id, name, email, salary FROM employees WHERE name LIKE '%$q%'

Example Injection Payload:
%' OR '1'='1' --

Impact:
An attacker can retrieve all employee records including sensitive data.

## Environment Setup

Requirements:
- Docker
- Docker Compose
- Git

## Installation Steps

1. Clone the repository:
git clone https://github.com/19melek19/TheMisfits-CVE-2024-8465-SQLi.git

2. Navigate into the project directory:
cd TheMisfits-CVE-2024-8465-SQLi

3. Start the vulnerable environment(We recommend that you use the terminal in Docker Desktop):
docker compose up --build

## Application Access

Login Page:
http://localhost:8080/index.php

Search Page:
http://localhost:8080/search.php

## Demonstration

The demo shows:
- Failed login with valid-looking credentials
- Successful login using SQL injection
- Database data exposure through the search feature

A screen-recorded demonstration video is provided separately.
YouTube link: https://youtu.be/AFfSEyZrUnw

## Academic Note

This project is a representative vulnerable implementation inspired by CVE-2024-8465.
It is not the original affected software.

## Disclaimer

This project contains intentional security vulnerabilities.
Do not deploy this application in a production environment.
The authors are not responsible for any misuse.
