#!/bin/bash

# Function to check if a command is available
command_exists() {
    command -v "$1" &>/dev/null
}

# Function to check if the user has root privileges
check_root() {
    if [[ $EUID -ne 0 ]]; then
        echo "This script requires root privileges. Please run it with 'sudo'."
        exit 1
    fi
}

# Check for root privileges
check_root

# Check for Python 3
if command_exists python3; then
    echo "Python 3 is already installed."
else
    echo "Python 3 is not installed. Installing..."
    sudo apt update
    sudo apt install -y python3
fi

# Check for pip3 (for Python 3)
if command_exists pip3; then
    echo "pip3 is already installed."
else
    echo "pip3 is not installed. Installing..."
    sudo apt install -y python3-pip
fi

if command_exists pip; then
    echo "pip is already installed."
else
    echo "pip is not installed. Installing..."
    sudo apt install -y python-pip
fi

if command_exists gnome-terminal; then
  echo "Gnome terminal already installed"
else
  sudo apt install -y gnome-terminal && sudo apt update && sudo apt upgrade
  echo "Gnome terminal installed successfully"
fi

echo "Changing rights for script that starts listener and web server..."
chmod +x ./serve.sh

echo "Everything installed. Happy hacking."
