# ipeeyoupeewepee

![Project Logo](img/matthewpiss.png)

A scanner and attack suite for hosts on the public internet (mostly Cisco routers) that forward unauthenticated packets encapsulated in the IP-in-IP and GRE protocols.

This vulnerability, known as "Insecure Implementation of Tunneling Protocols," is tracked under CVE-2020-10136 and CVE-2024-7595. It allows you to send (but not receive) any IP packet from the affected hosts.

At first glance, the ability to send but not receive packets may seem useless. However, many of the affected hosts are located on networks that do not implement reverse-path filtering. This means that you can spoof IP addresses on the public internet using these vulnerabilities without needing a host that lacks source address validation (commonly referred to as IP Header Modification or IPHM) to launch attacks such as DNS amplification distributed denial-of-service (DDoS).

This tool is intended for educational purposes only.

The tool does not include scanning for similar vulnerabilities in the 6in4 and IP6IP6 protocols, as IPv6 is not a real protocol used by serious individuals.

## Scanner

```bash
cd scanner/
cargo build --release
sudo ./target/release/ipeeyoupeewepee <source_ip> <src_port> <rate_limit> <protocol_type (GRE|IPIP)>
```

Parameters:

- `<source_ip>`: The public IPv4 address from which you are scanning.
- `<src_port>`: The UDP port on which the scanner will listen for forwarded packets. **Ensure that this port is open in your firewall.**
- `<rate_limit>`: The packet rate limit in packets per second (e.g. `1000`).
- `<protocol_type>`: The encapsulation protocol to scan for, either `GRE` or `IPIP`.

## Attack suite

To utilize the attack suite located in the `tools/` directory, ensure that you have `python3` and `scapy` installed. Alternatively, you can run `poetry install` and `poetry shell` as root within the `tools/` directory to set up and access a virtual environment.

### can_i_spoof.py

This script checks whether the vulnerable host is capable of forwarding spoofed IP packets.

```bash
sudo python3 can_i_spoof.py <source_ip> <source_port> <tunnel_ip> <spoof_ip> <protocol (GRE|IPIP)>
```

Parameters:

- `<source_ip>`: The public IPv4 address from which you are scanning.
- `<source_port>`: The UDP port for listening to the forwarded packets.
- `<tunnel_ip>`: The IP address of the vulnerable IPIP or GRE host.
- `<spoof_ip>`: The IP address you intend to spoof.
- `<protocol>`: The encapsulation protocol to exploit, either GRE or IPIP.

Example Usage:

If your machine's IP address is 192.0.2.42 and you have UDP port 31337 open in your firewall, and you have identified a vulnerable GRE forwarding host at 198.51.100.25, you can check if it can spoof the IP address 203.0.113.23 with the following command:

```bash
sudo python3 can_i_spoof.py 192.0.2.42 31337 198.51.100.25 203.0.113.23 GRE
```

### abuse_honeypot.py

This script utilizes a vulnerable GRE or IPIP tunneling host to send spoofed TCP SYN packets to port 22 of random hosts across the internet, aiming to generate mass abuse reports against the specified target IP.

```bash
sudo python3 abuse_honeypot.py <tunnel_ip> <spoof_ip> <protocol (GRE|IPIP)>
```

Parameters:

- `<tunnel_ip>`: The IP address of the vulnerable IPIP or GRE host.
- `<spoof_ip>`: The IP address you intend to spoof.
- `<protocol>`: The encapsulation protocol to exploit, either GRE or IPIP.

Example Usage:

If you have identified a vulnerable GRE forwarding host at 198.51.100.25 and want to spoof TCP SYN packets on port 22 from the IP address 203.0.113.23, you can execute the following command:

```bash
sudo python3 abuse_honeypot.py 198.51.100.25 203.0.113.23 GRE
```

### dns_reflect.py

This script uses vulnerable GRE or IPIP tunneling hosts to reflect DNS responses back to a specified target, demonstrating a method for executing a DNS reflection distributed denial-of-service (DDoS) attack. This example is basic and can likely be enhanced to achieve greater amplification and packet rates; any improvements are left as an exercise to the reader.


```bash
sudo python3 dns_reflect.py <tunnel_ips.txt> <dns_resolvers.txt> <spoof_ip>
```

Parameters:

- `<tunnel_ips.txt>`: A file containing a list of IP addresses of vulnerable IPIP or GRE hosts.
- `<dns_resolvers.txt>`: A file containing a list of DNS resolvers to use for reflecting answers back to the target.
- `<spoof_ip>`: The IP address you intend to spoof.

Example Usage:

To initiate an attack against the IP address 203.0.113.23, you would run the following command:

```bash
sudo python3 dns_reflect.py tunnel_ips.txt dns_resolvers.txt 203.0.113.23
```

In this example, tunnel_ips.txt should contain a list of vulnerable IPIP or GRE hosts, with the protocol specified at the beginning of each line, formatted as follows:

```
GRE 198.51.100.25
IPIP 198.51.100.45
GRE 198.51.100.124
GRE 198.51.100.200
IPIP 198.51.100.3
[...]
```

And `dns_resolvers.txt` should include a list of public recursive DNS resolvers, formatted like this:

```
9.9.9.9
8.8.8.8
1.1.1.1
[...]
```