<h1 align='center'>
  CVE-2024-7479 & CVE-2024-7481
</h1>
<h1 align='center'>
  TeamViewer User to Kernel Elevation of Privilege
</h1>

<p align='center'>
 <a href="https://opensource.org/licenses/MIT">
    <img src="https://img.shields.io/badge/License-MIT-yellow.svg" />
  </a>
  <a href="#">
  <img alt="GitHub Repo stars" src="https://img.shields.io/github/stars/PeterGabaldon/CVE-2024-7479_CVE-2024-7481?style=for-the-badge">
 </a>
 <a href="#">
    <img src="https://img.shields.io/badge/C++-00599C.svg?style=for-the-badge&logo=C++&logoColor=white"/>
 </a>
</p>

This repository contains the exploit proof of concept of a vulnerability in TeamViewer that enables an unprivileged user to load an arbitrary Kernel Driver into the system. I would like to thank Zero Day Initiative for the coordination with them to report and responsibly disclose the vulnerability.

<p align='center'>
  <img alt="Logo" src="logo.webp" width="310" height="320">
</p>

- [https://www.cve.org/CVERecord?id=CVE-2024-7479](https://www.cve.org/CVERecord?id=CVE-2024-7479)
- [https://www.cve.org/CVERecord?id=CVE-2024-7481](https://www.cve.org/CVERecord?id=CVE-2024-7481)
- [https://www.zerodayinitiative.com/advisories/ZDI-24-1289/](https://www.zerodayinitiative.com/advisories/ZDI-24-1289/)
- [https://www.zerodayinitiative.com/advisories/ZDI-24-1290/](https://www.zerodayinitiative.com/advisories/ZDI-24-1290/)
- [https://www.teamviewer.com/en/resources/trust-center/security-bulletins/tv-2024-1006/](https://www.teamviewer.com/en/resources/trust-center/security-bulletins/tv-2024-1006/)

<br/>

![PoC Execution](screenshots%2FPasted%20image%2020240620201213.png)

# Details

The details about the research that ended with these vulnerabilities can be found in the following three-part blog series on my blog. They cover these vulns in more detail and also show where I failed during the process. Part three is the fun one :P.

- [https://pgj11.com/posts/Finding-TeamViewer-0days-Part-1/](https://pgj11.com/posts/Finding-TeamViewer-0days-Part-1/)
- [https://pgj11.com/posts/Finding-TeamViewer-0days-Part-2/](https://pgj11.com/posts/Finding-TeamViewer-0days-Part-2/)
- [https://pgj11.com/posts/Finding-TeamViewer-0days-Part-3/](https://pgj11.com/posts/Finding-TeamViewer-0days-Part-3/)

# PoC Video 📺

Videos of the exploit can be found here:
- [https://youtu.be/lUkAMAK-TPI](https://youtu.be/lUkAMAK-TPI)
- [https://youtu.be/3R0aBYd0Qn4](https://youtu.be/3R0aBYd0Qn4)
- [https://youtu.be/kOjjFgkJQoc](https://youtu.be/kOjjFgkJQoc)

# Summary

After being able to *spoof* (just some simple authentication as detailed in the blog) a valid TeamViewer client when connecting to the SYSTEM service IPC it was possible to trigger an arbitrary driver installation. TeamViewer was not verifying the signature of the driver being installed.

Thus a privilege scalation USER to KERNEL was possible thanks to TeamViewer.

One of the best approaches is to use the well-known technique *BYOD, Bring Your Own Vulnerable Driver* to load a valid signed driver into Windows Kernel and then exploit it in order to perform privileged actions from user level, like changing the token of an arbitrary process with a privileged one.

When TeamViewer is installed on the system, it creates a service that runs as SYSTEM, *TeamViewer_service.exe*

This service is a helper for the client to some tasks. Thus, the client does not run with elevated privileges and some tasks are delegated to the service.

The communication with the service (IPC) is implemented through sockets (using *Overlapped I/O* and *IoCompletionPort*). By default, TeamViewer SYSTEM services listens on ***5939/tcp*** at localhost.

TeamViewer is not filtering the parameter sent by the client to ask for the driver installation nor signature check, etc.

So the idea is: we will spoof a TV client an asks for a *VPN Driver* installation but indicating another INF. I reutilized the same original INF of TeamViewer but in another (non-privileged) path renaming the "bad" driver to _teamviewervpn.sys_, as this is the driver name being targetted by the original INF.

###### IMPORTANT NOTE

This bypasses also TeamViewer option *Changes require administrative rights on this computer*.

This check is only effective via the GUI, as *TeamViewer options* is disabled when clicking the button with an unprivileged user. But it is possible to connect to the socket and perform the arbitrary driver load.

###### IMPORTANT NOTE II

The exploit is version dependant because of the IPC message where the client specified its PID and another data among the version. The version of the client must match the version of the SYSTEM service. The exploit must be modified (lines 140 to 143) in Main.cpp to the TeamViewer_service.exe version that is being targeted.

######

So, basically, we spoof a TeamViewer client connecting the SYSTEM service and request the installation of an arbitrary driver. TeamViewer service kindly load it into the Kernel.

# CVE-2024-7481 Branch

TeamViewer has another IPC message very similar to the first one that I discovered first (thrown when clicking *Install VPN Driver*). This other message is to install the *Printer Driver*.

So, essentially, CVE-2024-7479 and CVE-2024-7481 are the same but TeamViewer committed the same error two times. The message are, although different, very similar. They have different IPC *Method Id*.

The results is the same, an arbitrary driver can be loaded.

### And always remember: "It's not who I am underneath, but what I do that defines me"

# 🦇

[![Linkedin badge](https://img.shields.io/badge/LinkedIn-0077B5?style=for-the-badge&logo=linkedin&logoColor=white)](https://www.linkedin.com/in/pedro-gabaldon-julia/)
[![Twitter badge](https://img.shields.io/badge/X-000000?style=for-the-badge&logo=x&logoColor=white)](https://x.com/PedroGabaldon)

[!["Buy Me A Coffee"](https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png)](https://www.buymeacoffee.com/petergabaldon)
