#  CVE-2024-5836 / CVE-2024-6778 

This repository contains proof of concept exploits for [CVE-2024-5836](https://nvd.nist.gov/vuln/detail/CVE-2024-5836) and [CVE-2024-6778](https://nvd.nist.gov/vuln/detail/CVE-2024-6778), which are vulnerabilities within the Chromium web browser which allowed for a sandbox escape from a browser extension. To run these, you must be on a version of Chromium older than `126.0.6478.54`.

Write up: https://ading.dev/blog/posts/chrome_sandbox_escape.html

Bug report: https://issues.chromium.org/issues/338248595

Both the `CVE-2024-5386` and `CVE-2024-6778` directories contains a POC Chrome extension that is able to execute arbitrary JS on privileged WebUI pages. `CVE-2024-5386` relies on a race condition and is fairly unreliable, while `CVE-2024-6778` does not.

The `sandbox-escape` directory contains the full exploit chain, using `CVE-2024-6778` to gain code execution in `chrome://policy`, which leads to a sandbox escape by setting the legacy browser support policies. 

This repository is licensed under the MIT license.