# Bootstrap 历史漏洞 PoC 集合

这是一个用于学习和研究的静态 HTML 页面，集成了多个 Bootstrap 框架历史上的跨站脚本（XSS）漏洞概念验证（PoC）。

此项目旨在为安全研究人员、开发者和学生提供一个安全、可控的环境，用于理解和验证这些特定的安全漏洞，而无需搭建复杂的服务器环境。

---

## ⚠️ 重要安全警告

* **仅供学习研究**：此项目及其所有代码仅用于授权的、合法的安全研究和教学目的。
* **严禁非法攻击**：严禁使用此工具或其包含的任何代码对任何您不拥有或未获明确授权的网站进行测试或攻击。未经授权的渗透测试是违法行为。
* **风险自负**：您对使用此项目所造成的一切后果负全部责任。

---

## 🚀 功能与包含的PoC

* **单一静态文件**：所有功能都集成在一个 HTML 文件中，无需后端或数据库。
* **手动版本切换**：通过简单地修改 HTML 文件中的注释，即可在不同的 Bootstrap 漏洞版本库之间切换，稳定可靠。
* **可重复触发**：部分 PoC 经过优化，可以被重复触发，便于观察和分析。
* **清晰的漏洞标识**：每个 PoC 都明确标注了其对应的 CVE 漏洞编号。

### PoC 列表

| PoC # | 漏洞编号 (CVE ID) | 漏洞描述 | 适用库版本 (范围) |
| :--- | :--- | :--- |:--- |
| **1** | `CVE-2019-8331` | Tooltip 组件的 `data-template` 属性未净化导致 XSS | `v4.x < v4.3.1` and `v3.x < v3.4.1` |
| **2** | `CVE-2018-14040` | Collapse 组件的 `data-parent` 属性未净化导致 XSS | `v4.x < v4.1.2` |
| **3** | `CVE-2016-10735` | Modal 组件的 `data-target` 属性未净化导致 XSS | `v3.x < v3.4.0` |
| **4** | `CVE-2024-6485` | Button 插件的 `data-loading-text` 属性未净化导致 XSS | `v3.x < v3.4.1` |

---

## 🛠️ 如何使用

1.  **获取文件**：下载或克隆本项目，得到 `test.html` 文件。
2.  **编辑文件**：用任何文本编辑器（如 VS Code, Sublime Text, 记事本等）打开 `test.html`。
3.  **选择库版本**：
    * 在文件的 `<head>` 部分，根据您想测试的 PoC（参考上方的列表），贴上对应版本的url。
4.  **保存并打开**：保存您修改后的 `test.html` 文件。
5.  **在浏览器中打开**：用您的浏览器打开这个本地的 HTML 文件。
6.  **触发 PoC**：与页面上对应的 PoC 元素进行交互（例如悬停或点击）以触发漏洞。

---

## 📜 许可证

此项目采用 [MIT 许可证](https://opensource.org/licenses/MIT)。
