# 🚀 pz-frontend-manager <= 1.0.5 - CSRF Profile Picture Exploit

## 🛠️ Description
This script exploits a **CSRF vulnerability** in the WordPress plugin **pz-frontend-manager** (versions <= **1.0.5**) to change the profile picture of a logged-in user without their consent.

🔴 **CVE-2024-6244**

The plugin lacks proper **CSRF protection**, allowing attackers to force authenticated users into performing unintended actions via crafted requests.

## 🕵️‍♂️ How It Works
1. **Checks for Vulnerability:** The script fetches `readme.txt` to determine if the target site is running a vulnerable version (`< 1.0.6`).
2. **Encodes the Image:** The provided image is converted to **Base64**.
3. **Logs in as the User:** Uses provided credentials to establish a session.
4. **Sends CSRF Exploit Request:** Uploads the profile picture by making a forged request to `admin-ajax.php`.
5. **Uploads Images & Extracts Path:** The script also uploads images and extracts their path from the result.
6. **Displays the Image URL:** If successful, the script outputs the new profile picture URL.
7. **Uploaded Images Path:** Here you can find the uploaded images in multiple formats:
   ```
   /wp-content/uploads/2025/02/

## 📌 Features
- Supports multiple image formats (**PNG, JPG, JPEG, GIF**).
- Automatically detects if the target site is vulnerable.
- Provides a detailed request response.
- Simple and easy to use.

## ⚡ Usage
```bash
python3 CVE-2024-6244.py -u <TARGET_URL> -U <USERNAME> -p <PASSWORD> -i <IMAGE_FILE>
```
```
usage: p.py [-h] --url URL --username USERNAME --password PASSWORD [--image IMAGE]

pz-frontend-manager <= 1.0.5 - CSRF change user profile picture

options:
  -h, --help            show this help message and exit
  --url URL, -u URL     Base URL of the WordPress site
  --username USERNAME, -U USERNAME
                        Username for login
  --password PASSWORD, -p PASSWORD
                        Password for login
  --image IMAGE, -i IMAGE
                        Image file name (default: Nxploit.jpg)
```

### 🔹 Example
```bash
python3 CVE-2024-6244.py -u "https://victim-site.com" -U "admin" -p "password123" -i "new_avatar.png"
```

## 📥 Requirements
- Python 3.x
- `requests` module (`pip install requests`)

## 🚨 Disclaimer
This script is for **educational and security research purposes only**. Unauthorized exploitation of websites without permission is **illegal** and may lead to severe consequences.

---


