
## CVE-2025-4517 - POC adding user to sudoers
 
This script is a weaponized version of the research published in the **Google Security Research Advisory:** https://github.com/google/security-research/security/advisories/GHSA-hgqp-3mmf-7h8f

While the original research demonstrates the vulnerability by modifying a simple "flag" file, this version is modified for a Local Privilege Escalation (LPE) scenario. Instead of just proving a file can be written outside the extraction directory, this version:

1. Targets the /etc/sudoers.d/ directory, which is a common persistence and privilege escalation vector in Linux.
2. Uses the same PATH_MAX overflow technique to "blind" the Python tarfile security filters (filter="data" or filter="tar").
3. Leverages the fact that once a filter is bypassed, the subsequent extract() operation trusts the path implicitly.
